/*
  reads input data
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include "fileInputStream.h"


FileInputStream::FileInputStream() {
  file=NULL;
  lopen=false;
  name=NULL;
}


FileInputStream::~FileInputStream() {
  close();
}


int FileInputStream::open(char* dest) {

  close();
  if (dest == NULL) {
    return false;
  }
  setUrl(dest);
  if (strlen(dest) == 1) {
    if (strncmp(dest,"-",1)==0) {
      file=::fdopen(0,"r");
    }
  }
  if (file == NULL) {
    int matchPos=InputStream::getPath(dest,"file");
    dest+=matchPos;
  }
  if (file == NULL) {
    file=fopen(dest,"r");
  }
  if (file == NULL) {
    perror("cannot open file");
  } else {
    lopen=true;
    name=new char[strlen(dest)+1];
    strncpy(name,dest,strlen(dest)+1);
  }
  return (file!=NULL);
}


void FileInputStream::close() {
  if (isOpen()) {
    delete name;
    name=NULL;
    ::fclose(file);
    file=NULL;
  }
  lopen=false;
  setUrl(NULL);
}


int FileInputStream::isOpen() {
  return lopen;
}


int FileInputStream::eof() {
  if (isOpen()==false){
    return true;
  }
  return feof(file);
}


int FileInputStream::read(char* ptr,int size) {
  int bytesRead=0;
  if (isOpen()) {
    bytesRead=fread(ptr, 1,size, file);
  } else {
    cerr << "read on not open file"<<endl;
    return 0;
  }
  if (bytesRead == 0){
    perror("zero bytes fread");
  }
  return bytesRead;
}


int FileInputStream::seek(long posInBytes) {
  int back=true;
  long pos;
  if (isOpen()==false) {
    return false;
  }
  pos=fseek(file, posInBytes,SEEK_SET);
  if (pos < 0) {
    perror("seek in setBytePos");
    back=false;
  }
  return back;
}


long FileInputStream::getByteLength() {
  long back=0;
  if (isOpen()) {
    struct stat fileStat;
    stat(name,&fileStat);
    back=(long)fileStat.st_size;
  }
  return back;
}


long FileInputStream::getBytePosition() {
  if (isOpen()) {
    return ftell(file);
  }
  return 0;
}



void FileInputStream::print() {
  printf("pos in file:%8x\n",(int)ftell(file));
}


 
