/*
  configuration for winamp skins
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __WASKINCONFIG_H
#define __WASKINCONFIG_H

#include <prefConfig.h>


#include <kconfig.h>

#include <qlabel.h>
#include <qpushbt.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qchkbox.h>
#include <qlined.h>
#include <qtabdlg.h>
#include <qlayout.h>
#include <qcombobox.h> 
#include <waDropSkinWidget.h>
#include <song.h>


class WaSkinConfig : public PrefConfig {
 Q_OBJECT
   
  KConfig* config;
  const char* configGroup;

  bool doWarn_cfg;
  bool playNext_cfg;

 public:
   WaSkinConfig(const char* configGroup,
		    QWidget * parent=0, const char * name=0 );
   ~WaSkinConfig();

   const char* getGroupName();
   void load();
   void save();
   void apply();
   
 signals:
   void applyEvent();

 public slots:
   void slotDrop(KDNDDropZone*);
   QString getSkinPath();
   void showAt(int pos);


 private:
   QComboBox* lineEdit;
   QStrList* urlList;
   WaDropSkinWidget* waDropSkinWidget;
   KDNDDropZone *dropZone;
   Buffer* dropfile;


};
#endif
