/*
  Winamp Skin
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __WASKIN_H
#define __WASKIN_H
#include <waJumpSlider.h>
#include <waVolumeSlider.h>
#include <waBalanceSlider.h>

#include <waSkinModell.h>
#include <waSkinOperation.h>


#include <standardGraph.h>
#include <qlayout.h>
#include <preferences.h>
#include <qwidget.h>
#include <guiPlugin.h>
#include <qpainter.h>
#include <waButton.h>
#include <waDigit.h>
#include <waBPS.h>
#include <waFreq.h>
#include <waInfo.h>
#include <waStatus.h>
#include <waStereo.h>
#include <waMono.h>


#include <guiBufferInfoDevice.h>
#include <guiSpectrumAnalyser.h>
#include <guiJumpDevice.h>
#include <guiBalanceDevice.h>
#include <guiShuffle.h>
#include <guiRepeat.h>

#include <waSkinConfig.h>
#include <waSkinConfigOption.h>

#define __SKINID_WINAMP       1

class WaSkin : public GuiPlugin {
  Q_OBJECT

    WaSkinModell* waSkinModell;

 public:
  WaSkin(QWidget *parent=0, const char *name=0 );
  ~WaSkin();

  void attachTo(StandardGraph* standardGraph);
  void detach();
  void configure();
  int  getSkinId();

  void setSong(Song* song);
  void setRepeat(int val);
  void setShuffle(int val);
  void setPlaylist(int val);

  QSize sizeHint() const;
  void paintEvent (QPaintEvent* paintEvent);

  

 private slots: 
   void apply();
   void pixmapChange();

 private:
   void createButtons();
   void createHighLevelElements();
   void sizeButtons();

   Preferences* preferences;
   WaSkinConfig* waSkinConfig;
   WaSkinConfigOption* waSkinConfigOption;

   WaButton* prev;
   WaButton* play;
   WaButton* pause;
   WaButton* stop;
   WaButton* next;
   WaButton* eject;
   WaButton* shuffle;
   WaButton* repeat;
   WaButton* playlist;
   WaButton* eq;

   GuiSpectrumAnalyser* guiSpectrumAnalyser;
   WaJumpSlider* waJumpSlider;
   WaVolumeSlider* waVolumeSlider;
   WaBalanceSlider* waBalanceSlider;
   WaDigit* waDigit;
   WaBPS* waBPS;
   WaFreq* waFreq;
   WaInfo* waInfo;
   WaStatus* waStatus;
   WaStereo* waStereo;
   WaMono* waMono;
};
#endif
