/*
  a nicer widget for the timer.The default yaf widget are (supposed) to be ugly
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#include "timerWidget.h"



TimerWidget::TimerWidget( QWidget *parent=0, const char *name=0 ):
             GuiTimerDevice( parent, name ) {

  led=new LED();
  setBackgroundColor(QColor(0,0,0));
}


TimerWidget::~TimerWidget() {
  delete led;
}


QSize TimerWidget::sizeHint() const {
  int w;
  int h;
  QPixmap* pixmap=led->getPixmap(_LED_DIGIT_8);
  w=pixmap->size().width();
  h=pixmap->size().height();
  QSize size(w*4+w/2,h);
  return size;
}


void TimerWidget::paintEvent ( QPaintEvent * paintEvent ) {
  int i;
  QSize size=sizeHint();
  int x=size.width();
  int y=0;
  char* timeString=getTimeString();
  char currentBst;
  int len=strlen(timeString);
  QPixmap* pixmapCurrent;
 
  QPainter paint;
  paint.begin( this );


  for(i=len-1;i>=0;i--) {
    currentBst=timeString[i];
    // default pixmap for unresolved symbols 
    pixmapCurrent=led->getPixmap(_LED_BLANK);
    if (currentBst == '-') {
      pixmapCurrent=led->getPixmap(_LED_MINUS);
    }
    if (currentBst == ' ') {
      pixmapCurrent=led->getPixmap(_LED_BLANK);
    }
    if (('0' <= currentBst) && (currentBst<= '9')) {
      pixmapCurrent=led->getPixmap(_LED_DIGIT_0+((int)currentBst-(int)'0'));
    }
    if (('A' <= currentBst) && (currentBst<= 'F')) {
      pixmapCurrent=led->getPixmap(_LED_A+((int)currentBst-(int)'A'));
    }
    if (currentBst == ':') {
      pixmapCurrent=led->getPixmap(_LED_DOTS);
    }    
    x=x-pixmapCurrent->width();
    paint.drawPixmap(x, y, *pixmapCurrent);
  }

  // fill missing information from the left to the right.
  while(x > 0) {
    pixmapCurrent=led->getPixmap(_LED_COL_RIGHT);
    x=x-pixmapCurrent->width();   
    paint.drawPixmap(x, y, *pixmapCurrent);
  }

  paint.end();  
  

}


 
