/*
  a class for led digits
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __LED_H
#define __LED_H

#include <iostream.h>
#include <qpixmap.h> 



/*
  This class defines a few led digits as they are on the most
  cd players.

*/


#define _MAX_LEDS  30

#define _LED_DIGIT_0    0
#define _LED_DIGIT_1    1
#define _LED_DIGIT_2    2
#define _LED_DIGIT_3    3
#define _LED_DIGIT_4    4
#define _LED_DIGIT_5    5
#define _LED_DIGIT_6    6
#define _LED_DIGIT_7    7
#define _LED_DIGIT_8    8
#define _LED_DIGIT_9    9

#define _LED_PANEL      10
#define _LED_DOTS       11
#define _LED_BLANK      12
#define _LED_PAUSE      13
#define _LED_PLAY       14
#define _LED_MINUS      15
#define _LED_STOP       16


#define _LED_COL_RIGHT  17
#define _LED_A          18
#define _LED_B          19
#define _LED_C          20
#define _LED_D          21
#define _LED_E          22
#define _LED_F          23

#define _LED_COPYRIGHT_TRUE    24
#define _LED_COPYRIGHT_FALSE   25
#define _LED_STEREO            26
#define _LED_MONO              27



#define _MAX_LED_ELEMENT 28

class LED {

 public:
  LED();
  ~LED();

  QPixmap* getPixmap(int type);

 private:
  QPixmap* pixmapArray[_MAX_LEDS];
};

#endif
