/*
  Configuration for the TimerDevice
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __TIMERDEVICECONFIG_H
#define __TIMERDEVICECONFIG_H

#include <prefConfig.h>


#include <kconfig.h>

#include <qlabel.h>
#include <qpushbt.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qchkbox.h>
#include <qlined.h>
#include <qtabdlg.h>
#include <qlayout.h>

#include <deviceConfig/info/timeInfo.h>
#include <deviceConfig/info/musicInfo.h>


#define _TIMEMODE_ARITH_DEC          1
#define _TIMEMODE_ARITH_HEX          2

#define _TIMEMODE_PLAYED             100
#define _TIMEMODE_REMAIN             101


class TimerDeviceConfig : public PrefConfig {
 Q_OBJECT
   
  KConfig* config;
  char* configGroup;

  int arith_cfg;
  int mode_cfg;
  

 public:
   TimerDeviceConfig(char* configGroup,
		    QWidget * parent=0, const char * name=0 );
   ~TimerDeviceConfig();

   const char* getGroupName();
   void load();
   void save();
   void apply();
   
   void translate(TimeInfo* timeInfo,MusicInfo* musicInfo,Buffer* dest);
   int getTimeMode();

  public slots:
   void setArith(int arith);
   void setTimeMode(int mode);

 private:
   void getFormatDec(int played,int len,Buffer* dest);
   void getFormatHex(int played,int len,Buffer* dest);


   QButtonGroup *a_bg;
   QButtonGroup *m_bg;
   Buffer* hexFormat;

};
#endif


