/*
  Configuration for the SpectrumAnalyser
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __SPECTRUMANALYSERDEVICECONFIG_H
#define __SPECTRUMANALYSERDEVICECONFIG_H

#include <prefConfig.h>


#include <kconfig.h>

#include <qlabel.h>
#include <qpushbt.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qchkbox.h>
#include <qlined.h>
#include <qtabdlg.h>
#include <qlayout.h>
#include <devices/spectrumAnalyserDevice.h>


class SpectrumAnalyserDeviceConfig : public PrefConfig {
 Q_OBJECT
   
  KConfig* config;
  const char* configGroup;
  QCheckBox* useSpaBox;
  int useSpa_cfg;
  int analyseMode_cfg;

 public:
   SpectrumAnalyserDeviceConfig(const char* configGroup,
		    QWidget * parent=0, const char * name=0 );
   ~SpectrumAnalyserDeviceConfig();

   const char* getGroupName();
   void load();
   void save();
   void apply();
   
 signals:
   void applyEvent();

 public slots:
   void setUseSpa(bool val);
   int getUseSpa();
   int getAnalyseMode();
   void setAnalyseMode(int val);
};
#endif
