/*
  gui part for the volume device (very simple)
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#ifndef __GUIVOLUMEDEVICE_H
#define __GUIVOLUMEDEVICE_H

#include <qslider.h>
#include <qpainter.h>
#include <qpushbt.h>
#include <qlayout.h>



#include <devices/volumeDevice.h>
#include <yafcore/buffer.h>

#include <guiDevice.h>





class GuiVolumeDevice : public GuiDevice {
  Q_OBJECT

  VolumeDevice* volumeDevice;

 public:
  GuiVolumeDevice( QWidget *parent=0, const char *name=0 );
  ~GuiVolumeDevice();
  void attachTo(VolumeDevice* volumeDevice);
  void detach();


  virtual void buildGui();
  QSize sizeHint ();

 public slots:

  virtual void setVolume(int percent);
  int getVolume();

 signals:
  void valueChanged(int percent);

 protected:
  QSlider *sb;

};


#endif
