/*
  simple control gui for a device
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#include <guiTimerDevice.h>



GuiTimerDevice::GuiTimerDevice(QWidget *parent=0, 
			       const char *name=0):GuiDevice( parent, name ) {

  timeString=new Buffer(10);
  audioStreamInfoDevice=NULL;

  setMinimumSize( sizeHint() );

  timerDeviceConfig=new TimerDeviceConfig("GuiTimerDevice",getPreferences());
  getPreferences()->addTab(timerDeviceConfig,
			   timerDeviceConfig->getGroupName());
  insertMenu(i18n("Configure"),this,SLOT(configure()));

  QTimer* timer=new QTimer(this);
  connect(timer,SIGNAL(timeout()),this,SLOT(timeout()));
  timer->start(300);
}


GuiTimerDevice::~GuiTimerDevice() {
  delete timeString;
}


void GuiTimerDevice::attachTo(AudioStreamInfoDevice* audioStreamInfoDevice) {
  this->audioStreamInfoDevice=audioStreamInfoDevice;
  GuiDevice::attachTo(audioStreamInfoDevice);
  // here we override the qt connection in guidevice
  // because we poll the timemessage instead of push,
  // this time polling save more cpu cycles.
  // nevertehless the device must produce the timeInfo
  disconnect(audioStreamInfoDevice->getEventQueue(),NULL,this,NULL);
}


void GuiTimerDevice::detach() {
  audioStreamInfoDevice=NULL;
  GuiDevice::detach();
}



void GuiTimerDevice::configure() {
  getPreferences()->show();
}


void GuiTimerDevice::mousePressEvent ( QMouseEvent* mouseEvent) {
  if (mouseEvent->button() ==  RightButton) {
    KPopupMenu* popupMenu=createPopupMenu();
    popupMenu->move(mapToGlobal(QPoint(mouseEvent->x(),mouseEvent->y())));
    popupMenu->exec();
    delete popupMenu;
  }
  if (mouseEvent->button() ==  LeftButton) {
    int mode=timerDeviceConfig->getTimeMode();
    if (mode == _TIMEMODE_PLAYED) {
      timerDeviceConfig->setTimeMode(_TIMEMODE_REMAIN);
      repaint(false);
      return;
    }
    if (mode == _TIMEMODE_REMAIN) {
      timerDeviceConfig->setTimeMode(_TIMEMODE_PLAYED);
      repaint(false);
      return;
    }
  }
}


void GuiTimerDevice::timeout() {
  repaint(false);
}



char* GuiTimerDevice::getTimeString() {
  if (audioStreamInfoDevice != NULL) {
    TimeInfo* timeInfo=audioStreamInfoDevice->getTimeInfo();
    MusicInfo* musicInfo=audioStreamInfoDevice->getMusicInfo();
    
    timerDeviceConfig->translate(timeInfo,musicInfo,timeString);
    return timeString->getData();
  }
  return "";
}


QSize GuiTimerDevice::sizeHint() const {
  return QSize(40,40);
}


void GuiTimerDevice::paintEvent ( QPaintEvent * paintEvent ) {
  QPainter paint;

  erase(0,0,width(),height());
  paint.begin( this );
  paint.drawText(0,10,getTimeString());
  paint.end();  
  
}







