/*
  radiobutton to select shuffle play
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <guiRepeat.h>


GuiRepeat::GuiRepeat(const char* text,QWidget *parent=0,const char *name=0) :
    QCheckBox(text,parent,name) {

  connect(this,SIGNAL(toggled(bool)),this,SLOT(processRepeat(bool)));
 
}

GuiRepeat::~GuiRepeat() {
}



void GuiRepeat::processRepeat(bool lSet) {
  int val=(int)lSet;
  emit(setRepeatEvent(val));
}


void GuiRepeat::setRepeat(int lSet) {
  setChecked((bool)lSet);
}



QSize GuiRepeat::sizeHint() const {
  return QSize(20,10);
}
