/*
  show the frequence in the stream
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __GUIFREQDEVICE_H
#define __GUIFREQDEVICE_H

#include <qpainter.h>
#include <qpushbt.h>
#include <qlayout.h>
#include <qslider.h>


#include <devices/audioStreamInfoDevice.h>
#include <yafcore/buffer.h>

#include <guiDevice.h>





class GuiFreqDevice : public GuiDevice {
  Q_OBJECT

  AudioStreamInfoDevice* audioStreamInfoDevice;

 public:
  GuiFreqDevice( QWidget *parent=0, const char *name=0 );
  ~GuiFreqDevice();
  void attachTo(AudioStreamInfoDevice* audioStreamInfoDevice);
  void detach();
 

  int getFreq();

  QSize sizeHint() const;
  void paintEvent (QPaintEvent* paintEvent);

 signals:
   void setFreqEvent();


 protected:
  void processEvent(char eventId);

};


#endif
