/*
  a basic control widget
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __GUICONTROL_H
#define __GUICONTROL_H


#include <kapp.h>
#include <qpushbt.h>
#include <qpainter.h>
#include <qlayout.h> 
#include <devices/genericPlayer.h>



class GuiControl : public QWidget {
 Q_OBJECT

  QBoxLayout * layout;
  QPushButton* pauseButton;
  QPushButton* playButton;
  QPushButton* stopButton;
  GenericPlayer* genericPlayer;
  
 public:
  GuiControl( QWidget *parent=0, const char *name=0 );
  ~GuiControl();
  QSize sizeHint() const;
  void buildGui();

 public slots:
  int close();
  int pause();
  int play();


  void attachTo(GenericPlayer* genericPlayer);
  void detach();

};


#endif

