/*
  gui part for the balance device (very simple)
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#include <guiBalanceDevice.h>




GuiBalanceDevice:: GuiBalanceDevice(QWidget *parent=0, const char *name=0 ) :
  GuiDevice(parent,name) {
 balance=0;
 volumeDevice=NULL;
 menuDescription=new MenuDescription(i18n("BalanceDevice"));
 menuDescription->insertMenu(i18n("Center"),this,SLOT(centerBalance()));

 connect(this,SIGNAL(valueChanged(int)),this,SLOT(setBalance(int)));

}


GuiBalanceDevice::~GuiBalanceDevice() {

}



void GuiBalanceDevice::buildGui() {
 sb=new QSlider(-100,100,1,0,QSlider::Horizontal,this,"slider");
 sb->setTickmarks( QSlider::NoMarks );
 sb->setGeometry(0,0,55,15);
 sb->setBackgroundColor(black);
 sb->installEventFilter(this);
 connect(this,SIGNAL(valueChanged(int)),sb,SLOT(setValue(int)));
 connect(sb,SIGNAL(valueChanged(int)),this,SIGNAL(valueChanged(int)));
}


bool GuiBalanceDevice::eventFilter( QObject *, QEvent *e ) {
  if ( e->type() == Event_MouseButtonPress ) {    // key press
    QMouseEvent* mouseEvent = (QMouseEvent*)e;
    if (mouseEvent->button() ==  RightButton) {
      mousePressEvent(mouseEvent);
      return TRUE;                        // eat event
    }
  }
  return FALSE;    
}


void GuiBalanceDevice::attachTo(VolumeDevice* volumeDevice) {
  this->volumeDevice=volumeDevice;
  GuiDevice::attachTo(volumeDevice);
  emit(valueChanged(getBalance()));
}


void GuiBalanceDevice::detach() {
  volumeDevice=NULL;
  GuiDevice::detach();
}



int GuiBalanceDevice::getBalance() {
  return balance;
}


void GuiBalanceDevice::setBalance(int value) {
  balance=value;
  if (volumeDevice != NULL) {
    volumeDevice->setBalance(value);
  }
}


void GuiBalanceDevice::centerBalance() {
  setBalance(0);
  sb->setValue(0);
}


void GuiBalanceDevice::mousePressEvent ( QMouseEvent* mouseEvent) {
  if (mouseEvent->button() ==  RightButton) {
    KPopupMenu* popupMenu=menuDescription->createPopupMenu();
    QPoint point=mouseEvent->pos();
    QPoint globalPos=mapToGlobal(point);
    popupMenu->move(globalPos.x(),globalPos.y());
    popupMenu->exec();
    delete popupMenu;
    return;
  }
}




QSize GuiBalanceDevice::sizeHint() const {
  return QSize(55,15);
}






