#include <deviceConfig/mem/garbageCollector.h>
#include "videoDevice.h"
#include "guiVideoDevice.h"
#include "videoPlayer.h"
#include "videoMixerDevice.h"
#include "videoMixerFilter.h"



// KDE include files
#include <kapp.h>


// YAF include file


#include <unistd.h>



/**
   This example adds device for video handling.
*/


int main(int nargs,char** args) {
  GarbageCollector::init();
  KApplication a( nargs, args, "videoDemo" );


  if (nargs <= 2) {
    printf("Usage:\n\n");
    printf("%s filename1.xpm filename2.xpm\n\n",args[0]);

    exit(0);
  }


  // player 1
  VideoPlayer* player1=new VideoPlayer();
  VideoDevice* videoDevice1=new VideoDevice();
  GuiVideoDevice* surface1=new GuiVideoDevice();

  player1->addListener(videoDevice1);
  surface1->attachTo(videoDevice1);

  // player 2
  VideoPlayer* player2=new VideoPlayer();
  VideoDevice* videoDevice2=new VideoDevice();
  GuiVideoDevice* surface2=new GuiVideoDevice();

  player2->addListener(videoDevice2);
  surface2->attachTo(videoDevice2);


  // mixer
  // ATTENTION:
  // take care to connect the player to the mixer, because
  // the videodevice looses statusmessages!

  VideoMixerDevice* mixerDevice=new VideoMixerDevice();
  player1->addListener(mixerDevice);
  player2->addListener(mixerDevice);
  VideoDevice* videoDevice3=new VideoDevice();
  GuiVideoDevice* surface3=new GuiVideoDevice();

  mixerDevice->addListener(videoDevice3);
  surface3->attachTo(videoDevice3);
  


  KURL url1(args[1]);
  KURL url2(args[2]);

  player1->open(&url1);
  player2->open(&url2);
  

  surface1->show();
  surface2->show();
  surface3->show();
  

  a.exec();
  return 0;

}



  


