/*
  a basic player
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "guiPlayer4.h"
#include "../SONGS.DEF"



GuiPlayer::GuiPlayer() { 
  topLayout = new QHBoxLayout(this);    
  QVBoxLayout* l=new QVBoxLayout();
  topLayout->addLayout(l);
  


  // First we build the Multimedia graph
  genericPlayer=Amplifier::createPlayer(_MP3_DECODER);
  audioDevice = new AudioDevice("/dev/dsp");
  audioStreamInfoDevice=new AudioStreamInfoDevice();

  // then connect them
  genericPlayer->addListener(audioDevice);
  genericPlayer->addListener(audioStreamInfoDevice);

 
  audioDevice->open();
  currentSong= new Song(song[2]);
  cout << "open file:"<<song[2]<<endl;
  genericPlayer->open(song[2]);
  // Then build the gui



  guiTimerDevice = new GuiTimerDevice(this);
  guiTimerDevice->attachTo(audioStreamInfoDevice);
  guiTimerDevice->show();
  l->addWidget(guiTimerDevice);
  

  guiControl=new GuiControl(this);
  guiControl->attachTo(genericPlayer);
  guiControl->buildGui();
  guiControl->show();
  l->addWidget(guiControl);

  guiInfoDevice = new GuiInfoDevice(this);
  guiInfoDevice->setSong(currentSong);
  guiInfoDevice->show();
  l->addWidget(guiInfoDevice);

  // ok now build the "uninteresting parts"
  buildGui();
}


GuiPlayer::~GuiPlayer() {
  // Every device in the tree must be deleted seperatley:
  delete audioDevice;
  delete audioStreamInfoDevice;
  delete genericPlayer;
  delete currentSong;
}



void GuiPlayer::wakeup() {
  genericPlayer->wakeup();
}


void GuiPlayer::setDeliverModus(int modus) {
  genericPlayer->setDeliverMode(modus);
}

void GuiPlayer::setNotifyMode(int modus) {
  (genericPlayer->getEventQueue())->setNotifyMode(modus);
}



void GuiPlayer::buildGui() {
  QWidget* w=this;



  // two vertical boxes in the horizontal one    
  QBoxLayout * producerLayout = new QBoxLayout( QBoxLayout::Down );    
  topLayout->addLayout(producerLayout);
  QBoxLayout * radioBoxes = new QBoxLayout( QBoxLayout::Down );    
  producerLayout->addLayout( radioBoxes );    
  // fill the leftmost vertical box  
  QRadioButton* b1 = new QRadioButton( w, "radio button 1" );  
  b1->setText( "producer Single delivery" );  
  b1->setMinimumSize( b1->sizeHint() );  
  b1->setMaximumSize( 500, b1->minimumSize().height() );  

  radioBoxes->addWidget( b1, AlignLeft|AlignTop );  
  QRadioButton* b2 = new QRadioButton( w, "rb2" ); 
  b2->setText( "producers continuous delivery" );  
  b2->setMinimumSize( b2->sizeHint() ); 
  b2->setMaximumSize( 500, b2->minimumSize().height() ); 
  radioBoxes->addWidget( b2, AlignLeft|AlignTop );  
  // since none of those will stretch, add some stretch at the bottom  
  radioBoxes->addStretch( 1 );  
  // insert all of the radio boxes into the button group, so they'll  
  // switch each other off   
  QButtonGroup* bg = new QButtonGroup(); 

  // In a yafDecoder it is relative safe to make a single
  // delivery. (But not in a device.)
  bg->insert( b1 ,_STREAMPRODUCER_DELIVERS_SINGLE);   
  bg->insert( b2 ,_STREAMPRODUCER_DELIVERS_CONTINOUS);
  connect(bg,SIGNAL(pressed(int)),this,SLOT(setDeliverModus(int)));

  QBoxLayout * radioBoxes2 = new QBoxLayout( QBoxLayout::Down );    
  producerLayout->addLayout( radioBoxes2 );    
  // fill the leftmost vertical box  
  QRadioButton* b3 = new QRadioButton( w, "radio button 1" );  
  b3->setText( "producer Eventqueue notify_all" );  
  b3->setMinimumSize( b3->sizeHint() );  
  b3->setMaximumSize( 500, b3->minimumSize().height() );  

  radioBoxes2->addWidget( b3, AlignLeft|AlignTop );  
  QRadioButton* b4 = new QRadioButton( w, "rb2" ); 
  b4->setText( "producers EventQueue notify_if_clear" );  
  b4->setMinimumSize( b4->sizeHint() ); 
  b4->setMaximumSize( 500, b4->minimumSize().height() ); 
  radioBoxes2->addWidget( b4, AlignLeft|AlignTop );  
  // since none of those will stretch, add some stretch at the bottom  
  radioBoxes2->addStretch( 1 );  
  // insert all of the radio boxes into the button group, so they'll  
  // switch each other off   
  QButtonGroup* bg2 = new QButtonGroup(); 

  // In a yafDecoder it is relative safe to make a single
  // delivery. (But not in a device.)
  bg2->insert( b3 ,_NOTIFY_ALL);   
  bg2->insert( b4 ,_NOTIFY_IF_CLEAR);
  connect(bg2,SIGNAL(pressed(int)),this,SLOT(setNotifyMode(int)));

 


  
  char* infoTxt="
  This demo shows how you can control the stream
  on device level. You have three options. 

  First you can control the delivery method of a 
  producer. The you can control how the device
  sends signals to the gui. (This is done
  with the eventQueue";
                


  QMultiLineEdit* info=new QMultiLineEdit(this);
  info->setText(infoTxt);
  topLayout->addWidget( info, AlignLeft|AlignTop|AlignBottom );
  

  
  QPushButton* confirm = new QPushButton( "producer wakeup", this, "confirm" );
  confirm->setMinimumSize( confirm->sizeHint() );    
  confirm->setMaximumSize( confirm->minimumSize().width(), 500 );    
  topLayout->addWidget( confirm, AlignLeft|AlignTop|AlignBottom );
  connect(confirm,SIGNAL(pressed()),SLOT(wakeup()));

  QPushButton *quit = new QPushButton( "Quit", this, "quit" );
  quit->setFont( QFont( "Times", 18, QFont::Bold ) ); 
  quit->setMinimumSize( quit->sizeHint() );    
  quit->setMaximumSize( quit->minimumSize().width(), 500 );    
  topLayout->addWidget( quit, AlignLeft|AlignTop|AlignBottom );
  connect( quit, SIGNAL(clicked()), qApp, SLOT(quit()) );

}
