#include <kapp.h>
#include <amplifier/amplifier.h>
#include <devices/genericPlayer.h>
#include <devices/audioDevice.h>
#include <deviceConfig/mem/garbageCollector.h>

#include <guiControl.h>
#include "openTest.h"

#include <unistd.h>
#include <crashHandler.h>



/**
   This example adds a gui to a simple multimedia graph.
   For this it uses the basic widgetset.


   Make sure youe have edited the file

   ../SONGS.DEF


*/



#include "../SONGS.DEF"

void crashTest(int nargs,char** args) {
  KApplication a( nargs, args);
  GarbageCollector::init();
 
  CrashHandler* ch=new CrashHandler();
  ch->open(song[3]);
  //ch->open("/mnt/diskG/b.mpeg");

  a.exec();
}



int main(int nargs,char** args) {

  // uncomment for the crashtest
  crashTest(nargs,args);

  KApplication a( nargs, args);

  GarbageCollector::init();
  GenericPlayer* player;
  AudioDevice* audioDevice=new AudioDevice("/dev/dsp");
  if (audioDevice->open() == false) {
    cout << "cannot open audio"<<endl;
    exit(0);
  }

  player=Amplifier::createPlayer(_MP3_DECODER);

  // First we build the multimedia graph:
  player->addListener(audioDevice);

  //player->setPlayOnOpen(false);

  OpenTest* openTest=new OpenTest();
  openTest->buildGui();
  //openTest->setText("/mnt/diskC/win98/media/ding.wav");
  //openTest->setText("/mnt/diskC/win98/media/ding.mp3");
  openTest->setText(song[3]);
  openTest->attachTo(player);
  openTest->show();
  
  cout << "open file:"<<song[3]<<endl;

  // Then we start the guiControl for the player
  GuiControl* guiControl=new GuiControl();
  guiControl->attachTo(player);
  guiControl->buildGui();
  guiControl->show();
  
  // enter qt event loop
  a.exec();
  delete player;
  return 0;
}



  
