
#include <kapp.h>
#include <amplifier/amplifier.h>
#include <devices/mixerDevice.h>
#include <devices/audioDevice.h>
#include <deviceConfig/mem/garbageCollector.h>
#include <qpushbutton.h> 
#include <unistd.h>


/**
   This example starts two decoders adds a mixer and an
   audiodevice to it. 

   Make sure youe have edited the file

   ../SONGS.DEF


*/



#include "../SONGS.DEF"




int main(int nargs,char** args) {

  KApplication a( nargs, args);


  if (nargs <= 2) {
    printf("Usage:\n\n");
    printf("%s filename1.mp3 filename2.wav\n\n",args[0]);
    exit(0);
  }

  cout << "open file:"<<args[1]<<endl;
  cout << "open file:"<<args[2]<<endl;
  GarbageCollector::init();
  GenericPlayer* player1=Amplifier::createPlayer(_MP3_DECODER);
  GenericPlayer* player2=Amplifier::createPlayer(_WAV_DECODER);
 
  MixerDevice* mixerDevice=new MixerDevice();
  AudioDevice* audioDevice=new AudioDevice("/dev/dsp");

  mixerDevice->addListener(audioDevice);
  player1->addListener(mixerDevice);
  player2->addListener(mixerDevice);

  if (audioDevice->open() == false) {
    cout << "cannot open audio"<<endl;
    exit(0);
  }
  player1->open(args[1]);
  player2->open(args[2]);
 
  QPushButton* b=new QPushButton("quit");
  QObject::connect(b,SIGNAL(clicked()),&a,SLOT(quit()));
  b->show();

  a.exec();
  

  cout << "shutdown start"<<endl;

  delete player1;
  delete player2;
  delete mixerDevice;
  delete audioDevice;
  cout << "clean shutdown"<<endl;


  return 0;
}



  
