/*
  configuration for startup behaviour
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#ifndef __STARTUPCONFIG_H
#define __STARTUPCONFIG_H


#include <prefConfig.h>


#include <kconfig.h>

#include <qlabel.h>
#include <qpushbt.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qchkbox.h>
#include <qlined.h>
#include <qtabdlg.h>
#include <qlayout.h>



class StartUpConfig  : public PrefConfig {
 Q_OBJECT
   
   KConfig* config;
   const char* configGroup;
   int lInsertLast_cfg;
   int lAutoplay_cfg;
   QString lastSong_cfg;

 public:
  StartUpConfig(const char* configGroup,
		QWidget * parent=0, const char * name=0 );
  ~StartUpConfig();

  const char* getGroupName();
  void load();
  void save();
  void apply();



 signals:
   void applyEvent();

 public slots:
  void pressedInsertLast();
  void pressedAutoplay();

  void setInsertLast(int lInsertLast);
  int getInsertLast();

  int getAutoplay();
  void setAutoplay(int lAutoplay);

  char* getLastSong();
  static void setLastSong(char* lastSong);
  

 private:
  QCheckBox* cb1;
  QCheckBox* cb2;
  QGroupBox* startUpBox;
  
 
};


#endif
