/*
  This defines the standard multimedia graph for the player.
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#ifndef __STANDARDGRAPH_H
#define __STANDARDGRAPH_H


#include <devices/spectrumAnalyserDevice.h>
#include <devices/volumeDevice.h>
#include <devices/audioStreamInfoDevice.h>
#include <crashConfig.h>
#include <decoderStarter.h>


/**
   Here we build the multimedia graph. For all instances of kmpg
   its the same, its the basic thing a multimedia stream should
   have. If you think that is not sufficient, then you
   can add new devices when you build your gui and
   attach it to the graph. Eg if you wrote your "very-cool-ocilloscope-device"
   and you don't like to use the default spectumAnalyser, then
   you dont attach in in the gui, and add your ocilloscope as a listener
   to the Standardgraph.
   There is no need to use any of these standarddevice, you
   can complety build your own.(This is already used by the server,
   who adds to the multimedia graph his mixerDevice, /dev/dsp 
   and the wavFileWriter)
*/

class StandardGraph : public NodeDevice {

 public:
  StandardGraph();
  ~StandardGraph();
  
  AudioStreamInfoDevice* getGeneralInfoDevice();
  AudioStreamInfoDevice* getBufferInfoDevice();
  AudioStreamInfoDevice* getJumpInfoDevice();
  VolumeDevice* getVolumeDevice();
  SpectrumAnalyserDevice* getSpectrumAnalyserDevice();

  char* getNodeName();
  void writeIn(NodeDevice* source,DeviceConfig* buf);
  
 private:
 
  // The devices:

  SpectrumAnalyserDevice* spectrumAnalyserDevice;
  VolumeDevice* volumeDevice;
  AudioStreamInfoDevice* audioStreamGeneralInfoDevice;
  AudioStreamInfoDevice* audioStreamBufferInfoDevice;
  AudioStreamInfoDevice* audioStreamJumpInfoDevice;
};
#endif

