/*
  Configuration for the crashHandling
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#ifndef __CRASHCONFIG_H
#define __CRASHCONFIG_H

#include <prefConfig.h>


#include <kconfig.h>

#include <qlabel.h>
#include <qpushbt.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qchkbox.h>
#include <qlined.h>
#include <qtabdlg.h>
#include <qlayout.h>

#include <tag.h>
#include <song.h>


class CrashConfig : public PrefConfig {
 Q_OBJECT
   
  KConfig* config;
  const char* configGroup;

  bool doWarn_cfg;
  bool doInform_cfg;
  bool playNext_cfg;

 public:
   CrashConfig(const char* configGroup,
		    QWidget * parent=0, const char * name=0 );
   ~CrashConfig();

   const char* getGroupName();
   void load();
   void save();
   void apply();
   
 signals:
   void applyEvent();
   void killDecoder();

 public slots:
   int getDoWarn();
   int getDoInform();
   int getPlayNext();


 private:

   QCheckBox* doWarnBox;
   QCheckBox* doInformBox;
   QCheckBox* playNextBox;

   QGroupBox* infoBox;
};
#endif
