/*
  Configuration for the audioDevice
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <wavFileDeviceConfig.h>


WavFileDeviceConfig::WavFileDeviceConfig(const char* configGroup,
				   QWidget * parent=0, const char * name=0 ) 
                 : PrefConfig(parent,name) {
  dirList=new QStrList();
  dirList->append("/tmp/");
  counterString="0";
  filenameString="-";
 
  updatePoll= new QTimer(this);
  connect(updatePoll,SIGNAL(timeout()),this,SIGNAL(updateEvent()));

  config = kapp->getConfig();
  this->configGroup=configGroup;
  load();

  QVBoxLayout *vbox = new QVBoxLayout(this, 5);
  vbox->addSpacing( fontMetrics().height() );

  eofBox = new QCheckBox(i18n("stop is eof"),
			    this,"enableBox");
  eofBox->setFixedSize(eofBox->sizeHint());
  eofBox->setChecked(lStopIsEOF_cfg);


  QLabel* lineLabel1=new QLabel(this);
  lineLabel1->setText(i18n("Enter the targetdirectory:"));
  lineLabel1->setFixedSize(lineLabel1->sizeHint());



  dirEdit= new QComboBox (true, this );
  dirEdit->setSizeLimit(5);
  dirEdit->insertStrList(dirList);
  dirEdit->setFixedSize(QSize(300, 25) );

  vbox->addWidget(eofBox,0,AlignLeft);
  vbox->addWidget(lineLabel1,0,AlignLeft);
  vbox->addWidget(dirEdit,0,AlignLeft);
 

  QGroupBox* infoBox= new QGroupBox(i18n("Writer state"),this, "infoBox" );

  QVBoxLayout *vbox1 = new QVBoxLayout(infoBox, 5);
  vbox1->addSpacing( infoBox->fontMetrics().height() );

  QWidget* w=new QWidget(infoBox);
  QVBoxLayout *vbox2 = new QVBoxLayout(w, 5);

  
  QLabel* lineLabel2=new QLabel(w);
  lineLabel2->setText(i18n("Current file:"));
  lineLabel2->setFixedSize(lineLabel2->sizeHint());


  filenameLabel=new QLabel(w);
  filenameLabel->setText(filenameString);
  filenameLabel->setFixedSize(QSize(300,20));
  

  QLabel* lineLabel3=new QLabel(w);
  lineLabel3->setText(i18n("Current size:"));
  lineLabel3->setFixedSize(lineLabel3->sizeHint());


  counterLabel=new QLabel(w);
  counterLabel->setText(counterString);
  counterLabel->setFixedSize(QSize(140,20));

  vbox2->addSpacing( 20 );
  vbox2->addWidget(lineLabel2,0,AlignLeft);
  vbox2->addWidget(filenameLabel,0,AlignLeft);
  vbox2->addWidget(lineLabel3,0,AlignLeft);
  vbox2->addWidget(counterLabel,0,AlignLeft);
  
 
  vbox1->addWidget(w,0,AlignLeft);

  vbox->addWidget(infoBox,0,AlignLeft);
  vbox->addStretch(2);
  
  
}

WavFileDeviceConfig::~WavFileDeviceConfig() {
  delete dirList;
}


const char* WavFileDeviceConfig::getGroupName() {
  return i18n("Wav");
}


void WavFileDeviceConfig::load() {
  config->setGroup(configGroup);
  lStopIsEOF_cfg=true;
}


void WavFileDeviceConfig::save() {

  config->setGroup(configGroup);
}


void WavFileDeviceConfig::apply() {
  save();
  emit(applyEvent());
}


const char* WavFileDeviceConfig::getDirectory() {
  return dirEdit->currentText();
}


void WavFileDeviceConfig::update(int lupdate) {

  if (lupdate == true) {
    emit(updateEvent());
    repaint(false);
    updatePoll->start(2000);
  } else {
    updatePoll->stop();
    emit(updateEvent());
  }

}



int WavFileDeviceConfig::getStopIsEOF() {
   return (int)eofBox->isChecked();
}



void WavFileDeviceConfig::setCurrentFile(char* file) {
  filenameString=file;
  filenameLabel->setText(filenameString);
}


void WavFileDeviceConfig::setByteCounter(long bytecounter) {
  counterString.setNum(bytecounter);
  counterLabel->setText(counterString);
}
 
