/*
  root window for kmpg (menu and all this stuff)
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <kmpgMainWindow.h>

static int instance=0;

#ifndef VERSION
#define VERSION "check automake tools"
#endif


KmpgMainWindow::KmpgMainWindow():
  KTMainWindow() {
  config = kapp->getConfig();
  load();
  this->selectInputDialog=selectInputDialog;

  standardGraph=new StandardGraph();
  playlist=new Playlist();
  ourInput=NULL;

  dropZone = new KDNDDropZone(this , DndURL );
  connect(dropZone,SIGNAL(dropAction(KDNDDropZone*)), 
	  SLOT( onDrop( KDNDDropZone*)));

  playlistView2=new PlaylistView2(playlist);
  connect(playlistView2,SIGNAL(hideRequestEvent()),
	  this,SLOT(playlistView2DoHide()));

  preferences=new Preferences();
  startUpConfig=new StartUpConfig("StartUpConfig",preferences);
  preferences->addTab(startUpConfig,startUpConfig->getGroupName());

  mixerConfig=new MixerConfig("MixerConfig",preferences);
  preferences->addTab(mixerConfig,mixerConfig->getGroupName());

  skinConfig=new SkinConfig("SkinConfig",preferences);
  preferences->addTab(skinConfig,skinConfig->getGroupName());
  /**
     Here we have two callbacks. One for the "apply the skin"
     and one for "configure"
  */
  connect(skinConfig,SIGNAL(applyEvent()),this,SLOT(applySkin()));
  connect(skinConfig,SIGNAL(configSkinEvent()),this,SLOT(configGuiPlugin()));

  openURLDialog=new OpenURLDialog("OpenURLDialog");
  connect(openURLDialog,SIGNAL(applyEvent()),this,SLOT(insertURL()));
  /**
     The last instance sets itself as ipc target
  */
  ipcConfig=new IPCConfig("IPCConfig",playlist,preferences);
  connect(ipcConfig,SIGNAL(closeIPCHandleForever()),
	  this,SIGNAL(closeIPCHandleForever()));
	  
  preferences->addTab(ipcConfig,ipcConfig->getGroupName());
  KmpgCommandLine::setPlaylist(playlist);

  playlistView3=new PlaylistView3(playlist);
  // we create a non gui player
  kmpgPlayer=new KmpgPlayer(playlist);

  buildMenuBar();
  connect(menuBar(),SIGNAL(moved(menuPosition)),
	  this,SLOT(menuBarMoved()));

  
    



  mainWidget=new ShellWidget(this);


  // after this we create one of those guiPlugins
  guiPlugin=skinConfig->createGuiPlugin(mainWidget);

  // then we make sure the (non gui) kmpgPlayer gets all
  // these nice events from the gui
  kmpgPlayer->setGuiPlugin(guiPlugin);
  
  // now we attach the gui to the multimedia graph
  guiPlugin->attachTo(standardGraph);
  // now we insert the plugin into the view
  mainWidget->setFixedSize(guiPlugin->sizeHint()); 


  move(100+30*instance,100+30*instance);
  instance++;
  setView(mainWidget);
  updateRects();

  
  connect(guiPlugin,SIGNAL(playlistClickedEvent(int)),
	  this,SLOT(playlistView2Show(int)));
  guiPlugin->show();
  show();

}





KmpgMainWindow::~KmpgMainWindow() {

  preferences->hide();
  delete preferences;
  if (KmpgCommandLine::getPlaylist() == playlist) {
    KmpgCommandLine::setPlaylist(NULL);
  }
  delete playlistView3;
  delete playlistView2;
  delete playlist;
  delete kmpgPlayer;
  delete openURLDialog;
}


NodeDevice* KmpgMainWindow::getOutputNode() {
  return standardGraph;
}

void KmpgMainWindow::setInputNode(DecoderStarter* ourInput) {
  this->ourInput=ourInput;
  ourInput->addListener(standardGraph);

  connect(kmpgPlayer,SIGNAL(openEvent(Song*,DecoderID*)),
	  ourInput,SLOT(open(Song*,DecoderID*)));
  connect(kmpgPlayer,SIGNAL(playEvent()),ourInput,SLOT(play()));
  connect(kmpgPlayer,SIGNAL(pauseEvent()),ourInput,SLOT(pause()));
  connect(kmpgPlayer,SIGNAL(stopEvent()),ourInput,SLOT(stop()));
  connect(kmpgPlayer,SIGNAL(jumpEvent(int)),ourInput,SLOT(jump(int)));
  connect(ourInput,SIGNAL(playNextEvent()),kmpgPlayer,SLOT(playNext()));
  
}



void KmpgMainWindow::removeInputNode() {
  disconnect(kmpgPlayer);
  ourInput=NULL;
}


DecoderStarter* KmpgMainWindow::getInputNode() {
  return ourInput;
}


void KmpgMainWindow::buildMenuBar() {
  KMenuBar *mBar;
  QPopupMenu* file;
  QPopupMenu* decoder;
  QPopupMenu* tools;
  QString aboutStr = "kmpg-" VERSION "\n\n";
  
  aboutStr +="(c) 1999 Martin Vogt (mvogt@rhrk.uni-kl.de)\n\n";
  aboutStr += i18n("An MPEG audio player for the KDE Desktop Environment");
  aboutStr += "\n";
  aboutStr += i18n("See Help for more information");

  mBar = menuBar();


  file = new QPopupMenu();
  file->insertItem( i18n("Open..."), this, 
		    SLOT(openFileSelector()), CTRL+Key_O );
  file->insertItem( i18n("Open URL"), openURLDialog, 
		    SLOT(show()));
  file->insertItem( i18n("New player"),this,SIGNAL(newPlayerEvent()));
  
  file->insertSeparator();
  file->insertItem( i18n("Close"), this,
		    SLOT(closeWindow()), CTRL+Key_W );
  file->insertItem( i18n("Quit"), this,
		    SLOT(quit()), CTRL+Key_Q );

  mBar->insertItem( i18n("&File"), file );


  tools = new QPopupMenu();
  tools->insertItem( i18n("Playlist"), this, 
		    SLOT(playlistView2DoShow()), CTRL+Key_P );
  tools->insertItem( i18n("Mixer"), mixerConfig, 
		    SLOT(startExternalMixer()));
  tools->insertItem( i18n("Tag Editor"),playlistView3 , 
		    SLOT(show()));
  tools->insertSeparator();

  tools->insertItem( i18n("Output selection"),this,SIGNAL(outputSelectEvent()));
  tools->insertItem( i18n("Input selection"),kmpgPlayer,SLOT(configure()));




  decoder = new QPopupMenu();
  decoder->insertItem( i18n("Input"),this ,  SIGNAL(inputConfig()));
  decoder->insertItem( i18n("Output"),this , SIGNAL(outputConfig()));
  decoder->insertItem( i18n("Preferences"), preferences, SLOT(show()));
  
  tools->insertItem( i18n("Decoder"),decoder);

  mBar->insertItem( i18n("&Options"), tools );

  mBar->insertSeparator();
  mBar->insertItem( i18n("&Help"),
		    kapp->getHelpMenu(false, aboutStr) );


  
}
  

Playlist* KmpgMainWindow::getPlaylist() {
  return playlist;
}

void KmpgMainWindow::load() {
  config->setGroup("KmpgMainWindow");
  menuPos_cfg=config->readNumEntry("menuPos",(int)KMenuBar::Top);

  apply();
}


void KmpgMainWindow::save() {
  config->setGroup("KmpgMainWindow");
  config->writeEntry("menuPos",menuPos_cfg);
}


void KmpgMainWindow::apply() {
  KMenuBar* mBar=menuBar();
#if (KDE_VERSION_RELEASE > 3)
  if (menuPos_cfg != KMenuBar::Flat) {
    mBar->setMenuBarPos((KMenuBar::menuPosition)menuPos_cfg);
  } else {
    mBar->setFlat(true);
  }
#else
  cout << "too old KDE. flat menu disabled"<<endl;
#endif

}

void KmpgMainWindow::menuBarMoved(){
  KMenuBar* mBar=menuBar();


  menuPos_cfg=mBar->menuBarPos();
  
  save();

}


void KmpgMainWindow::openFileSelector() {
  // did we insert a song or has the user canceld ?
  if (PlaylistOperation::loadSong(playlist)) {
    int count=playlist->count();
    playlist->setCurrentPos(count-1);
    PlaylistOperation::playNextNotCorrupt(playlist);
  }

}


void KmpgMainWindow::onDrop( KDNDDropZone* zone) {
  int count=playlist->count();

  PlaylistOperation::rootInsert(zone,playlist);

  playlist->setCurrentPos(count);
  PlaylistOperation::playNextNotCorrupt(playlist);
  
}


void KmpgMainWindow::closeEvent(QCloseEvent* closeEvent) {
  emit(removeDecoder(this));
  KTMainWindow::closeEvent(closeEvent);
}


/**
   Here we must shutdown the current skin and switch
   on the new
*/
void KmpgMainWindow::applySkin() {
  // if they are not the same we delete the old plugin
  // and switch to the new
  if (guiPlugin->getSkinId() != skinConfig->getSkinId()) {
    guiPlugin->hide();
    guiPlugin->recreate(NULL,0,QPoint(0,0));
    delete guiPlugin;
    mainWidget->hide();
    
    guiPlugin=skinConfig->createGuiPlugin(mainWidget);
    mainWidget->show();

    // now we attach the gui to the multimedia graph
    guiPlugin->attachTo(standardGraph);  
    // inform the non gui player so that he now get the
    // events from the new gui
    kmpgPlayer->setGuiPlugin(guiPlugin);

    // and insert the plugin in our main window
    mainWidget->setFixedSize(guiPlugin->sizeHint());
    updateRects();

    
    guiPlugin->show();
    show();
    
    guiPlugin->setPlaylist(playlistView2->isVisible());
    connect(guiPlugin,SIGNAL(playlistClickedEvent(int)),
	    this,SLOT(playlistView2Show(int)));

  }
}


/**
   This starts the configurationdialog of the current skin
*/
void KmpgMainWindow::configGuiPlugin() {
  guiPlugin->configure();
}


void KmpgMainWindow::quit() {
  (kapp->getConfig())->sync();
  exit(0);
}


void KmpgMainWindow::closeWindow() {
  guiPlugin->detach();
  emit(removeDecoder(this));
  close();
}


Preferences* KmpgMainWindow::getPreferences() {
  return preferences;
}


void KmpgMainWindow::insertURL() {
  const char* url=openURLDialog->getCurrentURL();
  PlaylistOperation::rootInsert((char*)url,playlist);
  playlist->setCurrentPos(playlist->count()-1);
  PlaylistOperation::playCurrent(playlist);
}


void KmpgMainWindow::playlistView2DoShow() {
  playlistView2Show(true);
}

void KmpgMainWindow::playlistView2DoHide() {
  playlistView2Show(false);
}

void KmpgMainWindow::playlistView2Show(int val) {
  if (val == true) {
    if (playlistView2->isVisible()) {
      playlistView2->hide();
    }
    playlistView2->show();
    guiPlugin->setPlaylist(true);
  } else {
    playlistView2->hide();
    guiPlugin->setPlaylist(false);
  }
}
   
