/*
  parses kmpg commandLine options and performs necessary commands
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __KMPGCOMMANDLINE_H
#define __KMPGCOMMANDLINE_H

#include <qobject.h>
#include <iostream.h>
#include <unistd.h>
#include <stdio.h>
#include <playlistOperation.h>
#include <ipc/commandLineCreator.h>
#include <startUpConfig.h>
#include <kmsgbox.h>
#include <kapp.h>


#define _IPC_NOARGUMENT_PLAY      1
#define _IPC_NOARGUMENT_APPEND    2
#define _IPC_NOARGUMENT_IGNORE    3


class KmpgCommandLine : public QObject{
 Q_OBJECT
 public:
  KmpgCommandLine();
  ~KmpgCommandLine();

 public slots:
  static void usage();
  static void setPlaylist(Playlist* playlist);
  static Playlist* getPlaylist();

  static void setArgMode(int mode);
  static void parseIPC(CommandLineCreator* commandLineCreator);
  static void parse(int nargs,char** args);

};
#endif
