/*
  parses kmpg commandLine options and performs necessary commands
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <kmpgCommandLine.h>

static Playlist* playlist=NULL;
static int argMode=_IPC_NOARGUMENT_PLAY;


#ifndef VERSION
#define VERSION "check automake tools"
#endif



KmpgCommandLine::KmpgCommandLine() {
}


KmpgCommandLine::~KmpgCommandLine() {
}


void KmpgCommandLine::usage() {
  cout << "kmpg-"<< VERSION
       << i18n(" is a mp3 player for the K Desktop Environment")<<endl;
  cout << i18n("Usage : kmpg [-ah] file1 file2 ...")<<endl;
  cout << endl;
  cout << i18n("-a : appends files to playlist.")<<endl;
  cout << i18n("-h : this message")<<endl;
  cout << i18n("<no options> : plays file1 and append the rest to the playlist")<<endl;
  cout << endl;
  cout << i18n("THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY! ") \
       << i18n("USE AT YOUR OWN RISK!")<<endl;
  cout << endl;
}

void KmpgCommandLine::setPlaylist(Playlist* aPlaylist) {
  playlist=aPlaylist;
}


Playlist* KmpgCommandLine::getPlaylist() {
  return playlist;
}


void KmpgCommandLine::setArgMode(int mode) {
  argMode=mode;
}


/**
   The IPC communtication cannot use getopt, because getopt uses a static
   variable, which cannot be reset from the outside. Continous
   getopt calls then leads to sigsev. This is the reason why there
   must be an own parse function!
*/
 
void KmpgCommandLine::parseIPC(CommandLineCreator* commandLineCreator) {
  int insertMode=argMode;
  int i=1;
  int nargs=commandLineCreator->getNArgs();
  char** args=commandLineCreator->getArgs();
  QString msg;
  QStrList strList;
  
  if (playlist == NULL) {
    cout << "no playlist"<<endl;
    msg += i18n("kmpg has a IPC request, but no handle!");
    msg += "\n";
    msg += i18n("Request handle first. (preferences)");
    KMsgBox::message(NULL,i18n("IPC request error"),msg);

    delete commandLineCreator;
    return;
  }

  
  // Parse command arguments
  if (nargs >= 2) {
    if (strncmp(args[1],"-a",2) == 0) {
      insertMode=_IPC_NOARGUMENT_APPEND;
      i++;
    }
  }


  if (insertMode == _IPC_NOARGUMENT_IGNORE) {
    return;
  }

  while(i<nargs) {
    strList.append(args[i]);
    i++;
  }
  int count=playlist->count();
  int pos=playlist->getCurrentPos();
  if (insertMode == _IPC_NOARGUMENT_APPEND) {
    PlaylistOperation::rootInsert(&strList,playlist,count);
    playlist->setCurrentPos(pos);
  }
  if (insertMode == _IPC_NOARGUMENT_PLAY) {
    PlaylistOperation::rootInsert(&strList,playlist,count);
    playlist->setCurrentPos(count);
    PlaylistOperation::playCurrent(playlist);
  }

  delete commandLineCreator;
}


void KmpgCommandLine::parse(int nargs,char** args) {
  int c;
  int lPlay=true;
  int i=1;
  QStrList strList;

  if (playlist == NULL) {
    cout << "no playlist"<<endl;
    return;
  }
  if (nargs <= 1) {
    // no arguments try to play the last one.
    StartUpConfig* startUpConfig=new StartUpConfig("dummy");
    char* lastfile=startUpConfig->getLastSong();
    Song* song=new Song(lastfile);
    playlist->addSong(song);
    if (startUpConfig->getAutoplay() == true) {
      PlaylistOperation::playNext(playlist);
    }
    if (startUpConfig->getInsertLast() == false) {
      playlist->clear();
    }
    delete startUpConfig;
    return;
  }
  while(1) { 
    c = getopt (nargs, args, "a");
    if (c == -1) break;
    i++;
    switch(c) {
    case 'a': {    
      lPlay=false;
      break;
    }
    case 'h': {
      usage();
      exit(0);
    }
    default:
      printf ("?? getopt returned character code 0%o ??\n", c);
      usage();
      exit(-1);
    }
  }
  while(i<nargs) {
    strList.append(args[i]);
    i++;
  }

  int count=playlist->count();
  int pos=playlist->getCurrentPos();
  if (lPlay == false) {
    playlist->setCurrentPos(count);
  }
  PlaylistOperation::rootInsert(&strList,playlist);

  if (lPlay == false) {
    playlist->setCurrentPos(pos);
  }
  if (lPlay == true) {
    PlaylistOperation::playCurrent(playlist);
  }

}


