/*
  A single element transfered with the ipc mechanism
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#ifndef __IPCELEMENT_H
#define __IPCELEMENT_H

#include <yafcore/buffer.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <sys/un.h>
#include <iostream.h>
#include <sys/time.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>

#define _MAX_MSGLEN 30
#define _MAX_INTLEN 10


#define __IPC_ID_START        1
#define __IPC_ID_INT_DATA     2
#define __IPC_ID_CHAR_DATA    3
#define __IPC_ID_END          4
#define __IPC_ID_END_CONFIRM  5



/**
   This class cannot handle binary data, although the method
   indicate this. The reson is that the underlying buffer.h
   is not binary safe.
   Maybe in a future version, when binary transfer becomes 
   important, this class has to be improved.
*/

class IPCElement {

  int socket;
  int id;
  int len;
  Buffer* recvBuffer;
  Buffer* tmpBuffer;
  Buffer* dataBuffer;

  char* msgString;
  char* intString;
  int lEnd;

 public:
  IPCElement(int socket);
  ~IPCElement();

  int send(int id,int len, char* data);
  int send(int id,int value);
  int send(int id,char* data);
  
  int receive();
  
  int getID();
  int getLen();
  char* getData();
  int getInt();

  void setEnd(int lEnd);
  int getEnd();
  

  void print();
 private:
  int sendInt(int value);
  int sendChar(int nlen,char* data);

  int receiveInt(int* value);
  int receiveChar(Buffer* targetBuffer);

  int hasChar(Buffer* buffer,Buffer* targetBuffer);
  
};
#endif
