/*
  A single element transfered with the ipc mechanism
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <ipc/ipcElement.h>


IPCElement::IPCElement(int socket) {
  this->socket=socket;
  recvBuffer=new Buffer(30);
  dataBuffer=new Buffer(30);
  tmpBuffer=new Buffer(30);
  msgString=new char[_MAX_MSGLEN];
  intString=new char[_MAX_INTLEN];
  lEnd=false;
  
}


IPCElement::~IPCElement() {
  delete recvBuffer;
  delete msgString;
  delete intString;
  delete dataBuffer;
}


int IPCElement::send(int id,int len, char* data) {
  int back;

  back=sendInt(id);
  if (back < 0) {
    return false;
  }  
  back=sendInt(len);
  if (back < 0) {
    return false;
  }
  back=sendChar(len,data);
  return false;
}

int IPCElement::send(int id,int value) {
  char valString[30];
  int back;

  snprintf((char*)&valString,30,"%d",value);
  back=send(id,(char*)&valString);
  return back;
}


int IPCElement::send(int id,char* data) {
  return send(id,strlen(data),data);
}
 


int IPCElement::sendChar(int nlen,char* data) {
  int fullen;
  int back;

  snprintf(msgString,_MAX_MSGLEN,"l:%d m:",nlen);
  fullen=strlen(msgString);
  msgString[fullen]=0;

  back=::send(socket,msgString,fullen,0);
  if (back < 0) {
    perror("send");
    return false;
  }
  back=::send(socket,data,nlen,0);
  if (back < 0) {
    perror("send");
    return false;
  }  
  return true;
}  


int IPCElement::sendInt(int value) {
  int nlen;

  snprintf(intString,_MAX_INTLEN,"%d",value);
  nlen=strlen(intString);

  return sendChar(nlen,intString);
}  


int IPCElement::receiveInt(int* value) {
  int back=receiveChar(tmpBuffer);
  if (back == true) {
    sscanf(tmpBuffer->getData(),"%d",value);
  }
  return back;
}

void IPCElement::setEnd(int lEnd) {
  this->lEnd=lEnd;
}


int IPCElement::getEnd() {
  return lEnd;
}
 

int IPCElement::receiveChar(Buffer* targetBuffer) {
  int bytes;

  while(1) {
    if (hasChar(recvBuffer,targetBuffer) == true) {
      return true;
    }
    bytes=::recv(socket,msgString,_MAX_MSGLEN,0);

    if (bytes > 0) {
      msgString[bytes]=0;
      recvBuffer->append(msgString,bytes);
      if (hasChar(recvBuffer,targetBuffer) == true) {
	return true;
      }
      continue;
    }

    return false;
  }
  
}
    


int IPCElement::hasChar(Buffer* buffer,Buffer* targetBuffer) {
  char* str=buffer->getData();
  int spacePos;
  int nlen=strlen(str);
  if (nlen >= 4) {
    spacePos=3;
    while (spacePos<nlen) {
      if (str[spacePos]==' ') {
	int datalen;
	int restlen=nlen-((spacePos+1)+2);

	sscanf(str,"l:%d ",&datalen);
	if (restlen >= datalen) {
	  int forward_bytes=(spacePos+1)+2+datalen;
	  targetBuffer->clear();
	  targetBuffer->append(&(str[spacePos+1+2]),datalen);
	  buffer->forward(forward_bytes);
	  return true;
	}
	return false;
      }
      spacePos++;
    }
    return false;
  }
  return false;
}
    



int IPCElement::receive() {
  int back=receiveInt(&id);
  dataBuffer->clear();
  if (back == false) {
    return back;
  }

  back=receiveInt(&len);
  if (back == false) {
    return back;
  }
  back=receiveChar(dataBuffer);
  return back;
}


int IPCElement::getID() {
  return id;
}


int IPCElement::getLen() {
  return len;
}


char* IPCElement::getData() {
  return dataBuffer->getData();
}

int IPCElement::getInt() {
  int back;
  sscanf(dataBuffer->getData(),"%d",&back);
  return back;
}


void IPCElement::print() {
  cout << "IPCElement id:"<<id<<" len:"<<len;
  if (len > 0) {
    cout <<" data:"<<dataBuffer->getData()<<"***"<<endl;
  } else {
    cout <<" data:NULL"<<endl;
  }
}
