
#include <stdio.h>

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "kmp3db.h"

static const char *description =
	I18N_NOOP("Kmp3db, a program to find your mp3 very quick\nWith a double-click, the song will be played in your favourite mp3 player");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE
	
	
static KCmdLineOptions options[] =
{
  { "+[File]", I18N_NOOP("file to open"), 0 },
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[])
{

	KAboutData aboutData( "kmp3db", I18N_NOOP("Kmp3db"),
		VERSION, description, KAboutData::License_GPL,
		"(c) 2001, Edwin Schepers", "", "http://edwin.iscool.net/kmp3db.html");
	aboutData.addAuthor("Edwin Schepers",0, "yez@home.nl", "http://edwin.iscool.net/kmp3db.html");
	KCmdLineArgs::init( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KApplication app;
  if (app.isRestored())
  {
		printf("restore...\n");
    RESTORE(Kmp3dbApp);
  }
  else 
  {
    Kmp3dbApp *kmp3db = new Kmp3dbApp();
// what's the following ?
//		app.setMainWidget( kmp3db );
    kmp3db->show();

    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
		if (args->count())
		{
        kmp3db->openDocumentFile(args->arg(0));
		}
		else
		{
		  kmp3db->openDocumentFile();
		}
		args->clear();
  }

  return app.exec();
}  
