/*
 *	      StopWatch - a stopwatch for kmikmod
 *	(C)1998, 1999 Roope Anttinen - roope.anttinen@ntc.nokia.com
 *	
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 */

#include "stopwatch.h"

StopWatch::StopWatch()
{
	pthread_mutex_init (&ST_mutex, (pthread_mutexattr_t *)0);
	paused = false;
	stopped = true;
}

StopWatch::~StopWatch()
{
	pthread_mutex_destroy (&ST_mutex);
}

void StopWatch::start()
{
	pthread_mutex_lock (&ST_mutex);
	stopped = paused = false;
	Started = time((time_t *)0);
	pthread_mutex_unlock (&ST_mutex);
}

void StopWatch::pause(bool set)
{
	if(set) {
		pthread_mutex_lock (&ST_mutex);
		Paused = time ((time_t *)0);
		paused = true;
		pthread_mutex_unlock (&ST_mutex);
	} else if (stopped) {
		start();
	} else {
		pthread_mutex_lock (&ST_mutex);
		Started += (time((time_t *)0) - Paused);
		paused = false;
		pthread_mutex_unlock (&ST_mutex);
	}
}

void StopWatch::stop()
{
	pthread_mutex_lock (&ST_mutex);
	stopped = true;
	paused = false;
	pthread_mutex_unlock (&ST_mutex);
}

void StopWatch::step (int amount)
{
	pthread_mutex_lock (&ST_mutex);
	Started -= amount;
	pthread_mutex_unlock (&ST_mutex);
}

time_t StopWatch::elapsed()
{
	time_t ret = 0;
	pthread_mutex_lock (&ST_mutex);
	if (paused) ret = Paused - Started;
	else if (!stopped) ret = time((time_t *)0) - Started;
	pthread_mutex_unlock (&ST_mutex);
	return ret;
}
