/*
 *	      kmikmodData - main dialog for kmikmod
 *	(C)1998, 1999 Roope Anttinen - roope.anttinen@ntc.nokia.com
 *	
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 */

#ifndef kmikmodData_included
#define kmikmodData_included

#include <qdialog.h>
#include <qlabel.h>
#include <qpushbt.h>
#include <qslider.h>
#include <kbutton.h>

#include <ktopwidget.h>

#include "LCDWidget.h"

enum {MainW_H_Size=340, MainW_W_Size=125};

class kmikmodData : public KTopLevelWidget
{
    Q_OBJECT

public:

    kmikmodData
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );

    virtual ~kmikmodData();

public slots:


protected slots:
// As these are pure virtual functions, you have to implement 'em at some
// subclass through inheritance

    virtual void playPauseCB()=0;
    virtual void quitCB()=0;
    virtual void stopCB()=0;
    virtual void volumeCB(int)=0;
    virtual void nextCB()=0;
    virtual void prevCB()=0;
    virtual void ffCB()=0;
    virtual void frCB()=0;

protected:

    QLabel *PB_About;	// This used to be a push button thus the name.
    KButton *PB_FR;
    KButton *PB_Previous;
    KButton *PB_Next;
    KButton *PB_FF;
    KButton *PB_PlayPause;
    KButton *PB_Stop;
    QPushButton *PB_Quit;
    QPushButton *PB_Configure;
    QPushButton *PB_Eject;
    
    QLabel *LBL_Info;
    QLabel *LBL_Volume;
    QLabel *LBL_PBInfo;
    QFrame *FR_Main;
    QFrame *FR_Leds;

    QSlider* VolumeSlider;

    LCDWidget* LCD_play_time;

    LCDWidget* LCD_pat_position;
    LCDWidget* LCD_pat_lenght;
    LCDWidget* LCD_pattern;
    LCDWidget* LCD_tot_pats;
    LCDWidget* LCD_bpm;
};

#endif // kmikmodData_included
