/*
 *	      kmikmodData - main dialog for kmikmod
 *	(C)1998, 1999 Roope Anttinen - roope.anttinen@ntc.nokia.com
 *	
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 */

#include "kmikmodData.h"

#include <qframe.h>
#include <qpixmap.h>
#include <iostream.h>

kmikmodData::kmikmodData ( QWidget* parent, const char* name )
{
	FR_Main = new QFrame(this);
	FR_Main->setGeometry(80, 0, 180, 60);
	FR_Main->setIconText("kmikmod");
	FR_Main->setMouseTracking(true);

	LCD_play_time = new LCDWidget (FR_Main);
	LCD_play_time->setGeometry( 0, -1, 100, 50);
	LCD_play_time->setLineWidth( 0 );
	LCD_play_time->setNumDigits (5);

	QFont font( "Helvetica", 10, 75, 0 );
	font.setStyleHint( (QFont::StyleHint)0 );
	font.setCharSet( (QFont::CharSet)0 );

	LBL_Info = new QLabel (FR_Main);
	LBL_Info->setGeometry (5, 40, 145, 15);
	LBL_Info->setFont (font);
	
	LBL_Volume = new QLabel (FR_Main);
	LBL_Volume->setGeometry (150, 40, 30, 15);
	LBL_Info->setFont (font);
	
	LBL_PBInfo = new QLabel (FR_Main);
	LBL_PBInfo->setGeometry (110,3,60,15);
	LBL_PBInfo->setAlignment(AlignRight);
	LBL_PBInfo->setFont (font);
	
	FR_Leds = new QFrame(this);
	FR_Leds->setGeometry(0, 62, 208, 26);
	FR_Leds->setFrameStyle ( 50 );
	FR_Leds->setMouseTracking(true);

	LCD_pat_position = new LCDWidget(FR_Leds);
	LCD_pat_position->setGeometry( 0, 0, 38, 24 );
	LCD_pat_position->setLineWidth( 0 );
	LCD_pat_position->setNumDigits( 3 );

	LCD_pat_lenght = new LCDWidget(FR_Leds);
	LCD_pat_lenght->setGeometry( 40, 0, 38, 24 );
	LCD_pat_lenght->setLineWidth( 0 );
	LCD_pat_lenght->setNumDigits( 3 );

	LCD_pattern = new LCDWidget(FR_Leds);
	LCD_pattern->setGeometry( 80, 0, 38, 24 );
	LCD_pattern->setLineWidth( 0 );
	LCD_pattern->setNumDigits( 3 );

	LCD_tot_pats = new LCDWidget(FR_Leds);
	LCD_tot_pats->setGeometry( 120, 0, 38, 24 );
	LCD_tot_pats->setLineWidth( 0 );
	LCD_tot_pats->setNumDigits( 3 );

	LCD_bpm = new LCDWidget(FR_Leds);
	LCD_bpm->setGeometry( 170, 0, 38, 24 );
	LCD_bpm->setLineWidth( 0 );
	LCD_bpm->setNumDigits( 3 );

	VolumeSlider = new QSlider(this);
	VolumeSlider->setGeometry( 216, 65, 122, 20 );
	VolumeSlider->setOrientation( QSlider::Horizontal );
	VolumeSlider->setRange( 0, 128 );
	VolumeSlider->setSteps( 8, 32 );
	VolumeSlider->setValue( 96 );
	VolumeSlider->setTracking( true );
	VolumeSlider->setTickmarks( QSlider::NoMarks );
	VolumeSlider->setTickInterval( 0 );
	connect( VolumeSlider, SIGNAL(valueChanged(int)), SLOT(volumeCB(int)) );

	PB_About = new QLabel(this);
	PB_About->setGeometry(0, 0, 80, 60);
	PB_About->setAlignment(AlignCenter);
	PB_About->setFrameStyle(QFrame::WinPanel|QFrame::Raised);
//	PB_About->setAutoDefault(false);
//	PB_About->setDefault(false);
//	PB_About->setText("KMikMod");
//	PB_About->setAutoResize(false);
//	PB_About->setAutoRepeat(false);
	
	PB_FR = new KButton(this);
	PB_FR->setGeometry(0, 90, 40, 35);
	connect ( PB_FR, SIGNAL (clicked()), SLOT(frCB()) );
	
	PB_Previous = new KButton(this);
	PB_Previous->setGeometry(40, 90, 40, 35);
 	connect( PB_Previous, SIGNAL(clicked()), SLOT(prevCB()) );

	PB_Next = new KButton(this);
	PB_Next->setGeometry(80, 90, 40, 35);
	connect( PB_Next, SIGNAL(clicked()), SLOT(nextCB()) );

	PB_FF = new KButton(this);
	PB_FF->setGeometry(120, 90, 40, 35);
	connect( PB_FF, SIGNAL(clicked()), SLOT(ffCB()) );
	
	PB_PlayPause = new KButton(this);
	PB_PlayPause->setGeometry(170, 90, 40, 35);
	connect( PB_PlayPause, SIGNAL(clicked()), SLOT(playPauseCB()) );

	PB_Stop = new KButton(this);
	PB_Stop->setGeometry(210, 90, 40, 35);
	connect( PB_Stop, SIGNAL(clicked()), SLOT(stopCB()) );

	PB_Quit = new QPushButton(this);
	PB_Quit->setGeometry(260, 90, 80, 35);
	connect( PB_Quit, SIGNAL(clicked()), SLOT(quitCB()) );

	PB_Configure = new QPushButton(this);
	PB_Configure->setGeometry(260, 0, 80, 30);
	
	PB_Eject = new QPushButton(this);
	PB_Eject->setGeometry(260, 30, 80, 30);

	resize( MainW_H_Size, MainW_W_Size );
	setMinimumSize( MainW_H_Size, MainW_W_Size );
	setMaximumSize( MainW_H_Size, MainW_W_Size );
}


kmikmodData::~kmikmodData()
{
 	delete PB_About;
 	delete PB_FR;
 	delete PB_Previous;
 	delete PB_Next;
 	delete PB_FF;
 	delete PB_PlayPause;
 	delete PB_Stop;
 	delete PB_Quit;
 	delete FR_Main;
 	delete PB_Configure;
 	delete PB_Eject;
 	delete FR_Leds;
 	delete VolumeSlider;
}
