/*
 *	      Main module for kmikmod
 *	(C)1998, 1999 Roope Anttinen - roope.anttinen@ntc.nokia.com
 *	
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 */

#ifndef MAIN_H
#define MAIN_H

#include "kmikmodData.h"
#include "ModClass.h"
#include "PlayList.h"
#include "ConfigDLG.h"
#include "qtimer.h"

#include <kapp.h>
#include <drag.h>

class Main : public kmikmodData
{
	Q_OBJECT
	
	ModPlayer *player;
	PlayList *playlist;
	ConfigDLG *conf_dlg;
	QColor LCD_fg;		// base color for module info leds
	QColor LCD_bg;		// bg for module "
	QColor LCD_off;		// dim color for "
	QColor t_LCD_bg;	// base color for time led
	QColor t_LCD_fg;	// bg for main display (time, info)
	QColor t_LCD_off;	// dim color for time led
	QColor i_LCD_fg;	// base color for info display
	QPalette palette;	// palette for info texts
	QTimer *timer;		// timer for display updates
	QRect Geometry;		// needed for memorising geometry
	QString saveDir;	// directory where to store playlists
	
	bool feed_current;
	void zeroLCD();
	void setConfigInfo (const configuration &);

	void playPauseCB();
	void stopCB();
	void quitCB();
	void volumeCB(int);
	void nextCB();
	void prevCB();
	void ffCB();
	void frCB();

private slots:
	void playCB();
	void timeoutCB();
	void setColors();
	void ejectCB();
	void confCB();
	void confChangedCB();
	void itemsChanged();
	void aboutToExit();
	void Dropped (KDNDDropZone*);

public:
	Main (int, char **);
	~Main();
};
#endif // MAIN_H
