/*
 *	      ConfigDLG - configuration dialog for kmikmod
 *	(C)1998, 1999 Roope Anttinen - roope.anttinen@ntc.nokia.com
 *	
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 */

#ifndef ConfigDlg_H
#define ConfigDLG_H

#include <qtabdialog.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qlistbox.h>

#include <kcolorbtn.h>

#include "ModClass.h"

class ConfigDLG:public QTabDialog
{
	Q_OBJECT

	configuration conf;
	bool color_changed;				// Are colors changed.
	QRadioButton	*kHZ11, *kHZ22, *kHZ44, *kHZ48, // Mixing frequency.
			*bits8, *bits16;		// Sample bits.
	QCheckBox	*stereo,			// Output options.
			*interpolation,			// Interpolation ~ dolby NR
			*hqmixer,			// High quality mixer
			*surround,			// Surround - not working yet
			*fadeout;			// Fadeout during last pattern
	QCheckBox	*use_rt;			// Use rt scheduler.
	QSpinBox	*SP_FQ;				// Sleep time.
	KColorButton	*KB_Time, *KB_Info;		// Color selectors.
	QListBox	*LB_Driver;			// Output driver selector.
	QWidget *soundConf();
	QWidget *aboutFrame();
	QWidget *colorFrame();
	QWidget *driverFrame();

private slots:
	void colorChangedSlot (const QColor &);
	void defaults() {	// I hope these are reasonable defaults...
		kHZ22->setChecked(true);
		stereo->setChecked(true);
		bits16->setChecked(true);
		interpolation->setChecked(false);
		surround->setChecked(false);
		fadeout->setChecked(false);
		use_rt->setChecked(false);
		SP_FQ->setValue(1200);
	}

public:
	ConfigDLG(QWidget *parent = NULL, const char *name = NULL);
	virtual ~ConfigDLG();

	bool colorsChanged() {return color_changed;}
	void disableSuid() {use_rt->setEnabled(false);}
	void setConfig(const configuration &);
	void setDriverInfo(const char *);
	void setColors(const QColor &, const QColor &);
	const configuration &getConfig();
	const QColor timeColor() {color_changed = false;
				  return KB_Time->color();}
	const QColor infoColor() {color_changed = false;
				  return KB_Info->color();}
};

#endif // ConfigDLG_H
