/*
  this is a EventQueue. Every device has its own EventQueue.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <signal/toolkit/eventQueue.h>
#include "../../../../config.h"



EventQueue::EventQueue(char* owner) {
  if (::pipe(fd) < 0) {
    debugOutput( cout << "owner of queue:"<<owner<<endl );
    perror("pipe EventQueue");exit(1);
  }
  this->owner=owner;
  lData=false;
  ldebug=false;
  mode=_NOTIFY_IF_CLEAR;
  client=NULL;
  fcntl(fd[1],F_SETFL,O_NONBLOCK);
  sn=new QSocketNotifier( fd[0], QSocketNotifier::Read, NULL );
  connect(sn,SIGNAL(activated(int)),this,SLOT(receiveEvent(int)));
  pthread_mutex_init(&dataMut,NULL);
}


EventQueue::~EventQueue() {
  close(fd[0]);
  close(fd[1]);
  
  delete sn;
}


void EventQueue::sendEvent(unsigned char eventId) {
  pthread_mutex_lock(&dataMut);
  if (ldebug) {
    debugOutput( cout << "sendEvent entered:"<<owner<<" :"<<eventId<<" " );
  }
  if (mode == _NOTIFY_NO) {
    if (ldebug) {
      debugOutput( cout << "mode == _NOTIFY_NO exit"<<endl );
    }
    pthread_mutex_unlock(&dataMut);
    return;  
  }
  if (mode == _NOTIFY_IF_CLEAR) {
    if (ldebug) {
      debugOutput( cout << "mode == _NOTIFY_IF_CLEAR" );
    }
    if (lData==false) {
      lData=true;
      if (ldebug) {
	debugOutput( cout << " lData==false " );
      }
      pthread_mutex_unlock(&dataMut);
      if (write(fd[1],(void*)(&eventId),1) != 1) {
	debugOutput( cout << "eventqueue:"<<owner<<" is dropping events "<<endl );
      }
      if (ldebug) {
	debugOutput( cout << " write ready! "<<endl );
      }  
    } else {
      if (ldebug) {
	debugOutput( cout << " lData==true " );
      }
       pthread_mutex_unlock(&dataMut);
    } 
    return;
  }
  if (mode == _NOTIFY_ALL) {
    if (ldebug) {
      debugOutput( cout << "mode == _NOTIFY_ALL" );
    }
    lData=true;
    pthread_mutex_unlock(&dataMut);
    if (write(fd[1],(void*)(&eventId),1) != 1) {
      debugOutput( cout << "eventqueue:"<<owner<<" is dropping events "<<endl );
    }
    if (ldebug) {
	debugOutput( cout << " write ready! "<<endl );
    } 
    return;
  }
  debugOutput( cout << "unknown deliver mode!"<<endl );
  pthread_mutex_unlock(&dataMut);
}


void EventQueue::receiveEvent(int) {
  unsigned char dummy=0;
  ::read(fd[0],&dummy,1);
  if (ldebug) {
    debugOutput( cout << "receive event:"<<owner<<" :"<<dummy );
  }
  if (client != NULL) {
    if (ldebug) {
      debugOutput( cout << " forward event to client" );
    }
    client->processEvent((char)dummy);
    if (ldebug) {
      debugOutput( cout << "..back from client" );
    }
  }
  // calls wrapper in yafObject:
  if (dummy < 127) {
    emitEvent(dummy); 
  } else {
    debugOutput( cout << "forwarding global event"<<endl );
    emitGlobalEvent(dummy); 
    debugOutput( cout << "forwarding global eventready"<<endl );
  }
   
  if (ldebug) {
    debugOutput( cout << " ready"<<endl );
  }
  clearNotifyBit();
}


void EventQueue::setNotifyMode(int mode) {
  this->mode=mode;
}


void EventQueue::clearNotifyBit() {
  pthread_mutex_lock(&dataMut);
  lData=false;
  pthread_mutex_unlock(&dataMut);
}

int EventQueue::getNotifyBit() {
  return lData;
}



void EventQueue::setDebug(int flag) {
  ldebug=flag;
}


void EventQueue::addListener(NotifyClient* client) {
  this->client=client;
}

