/*
  creates/deletes MemChunks
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */

#include <deviceConfig/mem/garbageCollector.h>
#include "../../../../../../config.h"

#define _MAX_GARBAGE_ENTRIES 300

static MemChunk* markAsDeleteList[_MAX_GARBAGE_ENTRIES];
static int currentInsertPos;
static int lInit=false;



void GarbageCollector::init() {
  int i;
  
  if (lInit) {
    debugOutput( cout << "GarbageCollector already initialized"<<endl );
    exit(0);

  }
  currentInsertPos=0;
  for(i=0;i<_MAX_GARBAGE_ENTRIES;i++) {
    markAsDeleteList[i]=NULL;
  }
  lInit=true;
}
  
  

MemChunk* GarbageCollector::createMemChunk(MemManager* memManager,int size) {
  if (lInit == false) {
    debugOutput(cout << "GarbageCollector not initialized"<<endl );
    exit(0);
  }   
    
  return new MemChunk(memManager,size);
}


int  GarbageCollector::deleteMemChunk(MemChunk* memChunk) {
  if (lInit == false) {
    debugOutput(cout << "GarbageCollector not initialized"<<endl);
    exit(0);
  }
  
  if (memChunk->getLocks() > 0) {
    if (memChunk->getSize() == 0) {
      debugOutput(cout << "GarbageCollector detected lock on memChunk!->puffered"<<endl);
      char* ptr=memChunk->getPtr();
      int len=memChunk->getLen();
      memChunk->resize(len);
      memChunk->setPtr(ptr);
      if (currentInsertPos == _MAX_GARBAGE_ENTRIES) {
	debugOutput(cout << "garbagecollector full"<<endl);
	exit(0);
      }
      markAsDeleteList[currentInsertPos]=memChunk;
      memChunk->switchBackToInternalMemManager();
      currentInsertPos++;
    }
    return false;
  }
  // no locks
  delete memChunk;
  return true;
}



void GarbageCollector::makeGarbageCollection() {
  int i;
  int j;
  if (lInit == false) {
    debugOutput(cout << "GarbageCollector not initialized"<<endl);
    exit(0);
  }
  debugOutput(cout << "makeGarbageCollection() start"<<endl);
  for(i=0;i<_MAX_GARBAGE_ENTRIES;i++) {
    if (markAsDeleteList[i] != NULL) {
      if (GarbageCollector::deleteMemChunk(markAsDeleteList[i])) {
	for(j=i;j<_MAX_GARBAGE_ENTRIES -1;j++) {
	  markAsDeleteList[j]=markAsDeleteList[j+1];
	}
	debugOutput(cout << "GarbageCollector  -->deleted entry"<<endl);
	currentInsertPos--;
      }
    }
  }
  debugOutput(cout << "makeGarbageCollection() ready"<<endl);
  
}


int GarbageCollector::canMakeCollection() {
  return (currentInsertPos > 0);
}
