/* MPEG/WAVE Sound library  emusic driver.. (c) 1998 Isaac Richards */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "../common.h"
#include "rawtoemusic.h"

// emusicplayer class

Rawtoemusic::~Rawtoemusic()
{
   close_audio();
}

bool Rawtoemusic::initialize(char *filename)
{
   rawstereo = 1;
   rawsamplesize = 1;
   rawspeed = 44100;
   return true;
}

bool Rawtoemusic::setsoundtype(int stereo, int samplesize, int speed)
{
   close_audio();
   rawstereo = stereo;
   if (samplesize == 16)
      rawsamplesize = 1;
   else
      rawsamplesize = 0;
   rawspeed = speed;
   setup_audio(rawspeed, rawstereo, 1, 0, rawsamplesize);

   return true;
}

void Rawtoemusic::abort(void)
{
   flush_audio();
}

bool Rawtoemusic::putblock(void *buffer, int size)
{
  if (getEnable()) {
    audio_play((char *)buffer, size);
  }
  return true;
}


