/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#ifndef SONGTREE_H
#define SONGTREE_H

#include <kapp.h>
//#include <ktreelist.h> 
#include "../config.h"
#include <kiconloader.h>
#include <qpixmap.h>
#include <qlistbox.h>
#include "kjukebox.h"
#include <qgroupbox.h>
#include "database.h"
#include <drag.h>
#include "ktreeview.h"
#include "qpoint.h"

#define _SONGTREE_ARTIST_ALBUM_TITLE 0
#define _SONGTREE_TITLE_ARTIST_ALBUM 1

class SongTree : public KDNDWidget{
  Q_OBJECT
 private:
  int           titleWidth;
  int           timeWidth;
  //  KTreeList    *songTree;
  KTreeView    *songTree;
  int           displayMode;
  int           lastSelection;

  QStrList      artists;
  KIconLoader  *icon_loader;
  QGroupBox    *box;

  KPopupMenu   *rightButtonMenu;
  bool          pressed;
  int           press_x;
  int           press_y;
  
  void setupSurface(QString);
  void addSongsSortByArtist(QSongList songs);
  void addChildAlbumTitle_SortByArtist(Song *song, KPath *path, bool newArtist);
  void addSongsSortByTitle(QSongList songs);
  void addChildArtistAlbum_SortByTitle(Song *song, KPath *path, bool newTitle);
  
 public:
  SongTree(QString, QWidget *parent=0, const char *name=0);
  SongTree(QWidget *parent=0, const char *name=0);
  void clear();
  Song  getSelection();
  Song  getSelection(KTreeViewItem *);
  
 protected:
  void resizeEvent(QResizeEvent *);
  void dndMouseMoveEvent( QMouseEvent * );
  void dndMouseReleaseEvent ( QMouseEvent * );
  void mousePressEvent ( QMouseEvent * );
  void mouseReleaseEvent ( QMouseEvent * );

 signals:
  void selectionChanged();
  void doubleClick();
  void playSong(Song);
  void showMP3Info(Song);

  private slots:
  void doubleClick(int);
  void selectionChanged(int);
  void rightButtonPressed(int, const QPoint &);

  public slots:
    void clearSelection();
  void addSongs(QSongList);
  void setDisplayOrder(int mode);
};
  
#endif
