/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/


#include "commandLineParameters.h"
#include "appwindow.h"
#include <kapp.h>
#include <sys/resource.h>
#include <iostream.h>

int main( int argc, char ** argv ) {
  KConfig *config;
  KApplication app( argc, argv , "kjukebox");
  CommandLineParameters::parse(argc, argv);

  config = app.getConfig();

  config->setGroup(KCONFIG_GENERAL);
  int w = config->readNumEntry(KCONFIG_GENERAL_WIDTH,800);
  int h = config->readNumEntry(KCONFIG_GENERAL_HEIGHT,500);          
  if(config->readBoolEntry(KCONFIG_GENERAL_PRIOENABLE,false)){
    int defaultPrio = config->readNumEntry(KCONFIG_GENERAL_PRIOLEVEL,0);
    setpriority(PRIO_PROCESS,0,defaultPrio);
  }

  ApplicationWindow * mw = new ApplicationWindow();
  app.setMainWidget(mw);
  mw->setCaption( "KJukeBox " );
  mw->show();
  mw->resize(w,h);                           
  //  app.connect( &app, SIGNAL(lastWindowClosed()), mw, SLOT(quitKJukeBox()) );
  //  app.connect( &app, SIGNAL(saveYourself()), mw, SLOT(quitKJukeBox()));
  app.exec();
}

