/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#ifndef KJUKEBOX_H
#define KJUKEBOX_H

#include "song.h" 

#define _SORT_BY_ARTIST 0
#define _SORT_BY_TITLE  1
#define _START_SORT_ORDER _SORT_BY_ARTIST

#define GENRE_ALL "ALL"

/* Comment Field to save some Information */
#define MP3_COMMENT_FIELD "FS:%3d LS:%3d" 

/* KConfig Names */
#define KCONFIG_FILE    "File Options"
#define KCONFIG_FILE_IMPORTFORMAT     "importFormat"
#define KCONFIG_FILE_IMPORTSEPERATOR  "importSeperator"
#define KCONFIG_FILE_MP3COMMENT       "useMP3CommentField"
#define KCONFIG_FILE_CHECKFILES       "checkFiles"
#define KCONFIG_FILE_LASTDIRECTORY    "lastDirectory"

#define KCONFIG_PLAYER  "Player Options"
#define KCONFIG_PLAYER_DEFAULTTIME     "defaultTime"
#define KCONFIG_PLAYER_MIXING          "mixing"
#define KCONFIG_PLAYER_DEVICE          "audioDevice"
#define KCONFIG_PLAYER_LASTSECONDS     "lastSeconds"
#define KCONFIG_PLAYER_FIRSTSECONDS    "firstSeconds"
#define KCONFIG_PLAYER_FADEOUT         "fadeOut"
#define KCONFIG_PLAYER_FADEOUTDURATION "fadeOutDuration"
#define KCONFIG_PLAYER_FADEIN          "fadeIn"
#define KCONFIG_PLAYER_FADEINDURATION  "fadeInDuration"
#define KCONFIG_PLAYER_QUALITY         "quality"

#define KCONFIG_GUI     "Gui Options"
#define KCONFIG_GUI_DC_PLAYLIST       "dcPlayList"
#define KCONFIG_GUI_DC_DATABASE       "dcDataBase"
#define KCONFIG_GUI_DECODER_CRASHED   "decoderCrashed"
#define AUTO_REPAIR_WITHOUT_WARNING   0
#define AUTO_REPAIR_WITH_WARNING      1

#define KCONFIG_GENERAL "General Options"
#define KCONFIG_GENERAL_STATUSBAR     "statusBar"
#define KCONFIG_GENERAL_SOUNDTOOLBAR  "soundToolBar"
#define KCONFIG_GENERAL_MAINTOOLBAR   "mainToolbar"
#define KCONFIG_GENERAL_WIDTH         "width"
#define KCONFIG_GENERAL_HEIGHT        "height"
#define KCONFIG_GENERAL_SHUFFLE       "shufflePlaying"
#define KCONFIG_GENERAL_PRIOENABLE    "prioEnable"
#define KCONFIG_GENERAL_PRIOLEVEL     "prioLevel"
#define KCONFIG_GENERAL_REPEAT        "loop"
#define KCONFIG_GENERAL_UPCASE        "upcaseFirstLetter"

#define KCONFIG_MP3 "MP3 Options"
#define KCONFIG_MP3_LOAD_WITHOUT_TAG  "loadWithoutTag"
#define KCONFIG_MP3_DEFAULT_TITLE     "defaultTitle"
#define KCONFIG_MP3_DEFAULT_ARTIST    "defaultArtist"
#define KCONFIG_MP3_DEFAULT_ALBUM     "defaultAlbum"

#define KCONFIG_OPEN_RECENT_FILE "Recently_Opened_Files"
#define KCONFIG_OPEN_RECENT_FILE_1    "1"
#define KCONFIG_OPEN_RECENT_FILE_2    "2"
#define KCONFIG_OPEN_RECENT_FILE_3    "3"
#define KCONFIG_OPEN_RECENT_FILE_4    "4"

#define KCONFIG_PRINTER "Printer"
#define KCONFIG_PRINTER_FONT           "font"
#define KCONFIG_PRINTER_TAB1           "tab1"
#define KCONFIG_PRINTER_TAB2           "tab2"
#define KCONFIG_PRINTER_PAGE           "page"
#define KCONFIG_PRINTER_ORIENTATION    "orientation"

#define KCONFIG_SONGLOGGER  "SongLogger"
#define KCONFIG_SONGLOGGER_ENABLE     "enable"
#define KCONFIG_SONGLOGGER_LOGFILE    "filename"
#define KCONFIG_SONGLOGGER_COLWIDTH   "colwidth"
#define KCONFIG_SONGLOGGER_WIDTH      "width"
#define KCONFIG_SONGLOGGER_HEIGHT     "height"


/* Setting the AudioDevice for different Systems */
#ifdef OS_AIX 
#define DEFAULT_AUDIO_DEVICE "/dev/paud0/1"
#endif

#if defined(OS_Linux) || defined(OS_BSD)
#define DEFAULT_AUDIO_DEVICE "/dev/dsp"
#endif

#if defined(OS_HPUX) || defined(OS_SunOS)
#define DEFAULT_AUDIO_DEVICE "/dev/audio"
#endif

#if defined(__BEOS__) || defined(SOUND_ESD) || defined(OS_IRIX) || defined(OS_IRIX64)
#define DEFAULT_AUDIO_DEVICE ""
#endif

#ifndef DEFAULT_AUDIO_DEVICE
#define DEFAULT_AUDIO_DEVICE "/dev/dsp"
#endif


#endif // KJUKEBOX_H






