/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#ifndef FADEDEVICEGUI_H
#define FADEDEVICEGUI_H

#include <qobject.h>
#include <kapp.h>
#include <kconfig.h>
#include <qslider.h>
#include <kbutton.h>
#include <fadeDevice.h>


class FadeDeviceGui : public QWidget{
  Q_OBJECT
 private:
  QSlider  *fadeSlider;
  KButton  *fadeInButton;
  KButton  *fadeOutButton;

  bool fadeInActive;
  bool fadeOutActive;
  int  volume;

  void refresh();

 private slots:
  void setVolumeFromSlider(int);
  void fadeInButtonClicked();
  void fadeOutButtonClicked();

 protected:
  void resizeEvent (QResizeEvent *);

 public:
  FadeDeviceGui(QWidget *parent=0, const char *name=0);
  ~FadeDeviceGui();

 public slots:
  void fadeIn();
  void fadeOut();
  void stopFade();
  void setVolume(int);

 signals:
  void volumeChanged(int);
  void fadeInClicked();
  void fadeOutClicked();
  void stopFadingClicked();
};


#endif /* FadeDeviceGui_H */



