/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#include "configFile.h"

ConfigFile::ConfigFile(QWidget *parent, const char *name)
    : QWidget (parent,name)
{

  config = (KApplication::getKApplication())->getConfig();  
  config->setGroup(KCONFIG_FILE);
  format = config->readEntry(KCONFIG_FILE_IMPORTFORMAT,"AP|TI|AR|AL|YE|CO|GE|||||BI|SA|ST|||||SE|RP|SI|FS|LS");
  trennzeichen = config->readEntry(KCONFIG_FILE_IMPORTSEPERATOR, "|");
  useMP3CommentField = config->readBoolEntry(KCONFIG_FILE_MP3COMMENT, false);
  checkFiles = config->readBoolEntry(KCONFIG_FILE_CHECKFILES, true);


  //  box = new QGroupBox("Format",this,"box");
  boxImport = new QGroupBox(i18n("Import Format"), this,"box");
  edit = new KLined( boxImport, "edit" );
  edit -> setText(format);

  labelTrenn = new QLabel(boxImport, "labelTrenn");
  labelTrenn -> setText(i18n("Delimiter"));
  editTrenn = new KLined(boxImport, "editTrenn");
  editTrenn -> setText(trennzeichen);
  defaultButton = new QPushButton(boxImport,"default");
  defaultButton->setText(i18n("Default"));
  connect(defaultButton, SIGNAL(pressed()), this, SLOT(setDefault()));
  
  label1  = new QLabel(boxImport, "label1");   label1  -> setText("FN = Filename");
  label2  = new QLabel(boxImport, "label2");   label2  -> setText("TI = Titel");
  label3  = new QLabel(boxImport, "label3");   label3  -> setText("AR = Artist");
  label4  = new QLabel(boxImport, "label4");   label4  -> setText("AL = Album");
  label5  = new QLabel(boxImport, "label5");   label5  -> setText("YE = Year");
  label6  = new QLabel(boxImport, "label6");   label6  -> setText("CO = Comment");
  label7  = new QLabel(boxImport, "label7");   label7  -> setText("GE = Genre");
  label12 = new QLabel(boxImport, "label12");  label12 -> setText("BI = Bitrate");
  label13 = new QLabel(boxImport, "label13");  label13 -> setText("SA = Samplerrate");
  label14 = new QLabel(boxImport, "label14");  label14 -> setText("ST = Stereomode");
  label19 = new QLabel(boxImport, "label19");  label19 -> setText("SE = Seconds");
  label20 = new QLabel(boxImport, "label20");  label20 -> setText("LA = Layer");
  label21 = new QLabel(boxImport, "label21");  label21 -> setText("SI = Size");  
  label22 = new QLabel(boxImport, "label22");  label22 -> setText("FS = first Seconds");  
  label23 = new QLabel(boxImport, "label23");  label23 -> setText("LS = last Seconds");  

  boxSave = new QGroupBox(i18n("Addition Information"), this, "save");
  useMP3CommentFieldBox   = new QCheckBox(i18n("Use the MP3 comment field to save Settings\nWARNING: all comments are lost!"), boxSave,"a");
  useMP3CommentFieldBox->setChecked(useMP3CommentField);

  boxLoad = new QGroupBox(i18n("Load MP3 List"), this, "loadFiles");
  checkFilesBox  = new QCheckBox(i18n("check if each file exists"), boxLoad,"b");
  checkFilesBox->setChecked(checkFiles);

}

void ConfigFile::setDefault(){
  format = SAVELOADFORMAT;
  trennzeichen = SAVELOADTRENNZEICHEN;
  edit -> setText(format);
  editTrenn -> setText(trennzeichen);
}

void ConfigFile::cancel(){
  config->setGroup(KCONFIG_FILE);
  format = config->readEntry(KCONFIG_FILE_IMPORTFORMAT,"AP|TI|AR|AL|YE|CO|GE|||||BI|SA|ST|||||SE|RP|SI|FS|LS");
  trennzeichen = config->readEntry(KCONFIG_FILE_IMPORTSEPERATOR, "|");

  edit -> setText(format);
  editTrenn -> setText(trennzeichen);  
  
  useMP3CommentField = config->readBoolEntry(KCONFIG_FILE_MP3COMMENT,true);
  useMP3CommentFieldBox->setChecked(useMP3CommentField);

  checkFiles = config->readBoolEntry(KCONFIG_FILE_CHECKFILES,true);
  checkFilesBox->setChecked(checkFiles);
}

void ConfigFile::accept(){
  format = edit->text();
  trennzeichen =  editTrenn->text();
  useMP3CommentField = useMP3CommentFieldBox->isChecked();
  checkFiles = checkFilesBox->isChecked();
  
  config->setGroup(KCONFIG_FILE);
  config->writeEntry(KCONFIG_FILE_IMPORTFORMAT, format );
  config->writeEntry(KCONFIG_FILE_IMPORTSEPERATOR, trennzeichen );
  config->writeEntry(KCONFIG_FILE_MP3COMMENT, useMP3CommentField);
  config->writeEntry(KCONFIG_FILE_CHECKFILES, checkFiles);
  config->sync();
}

void ConfigFile::resizeEvent( QResizeEvent * ){
  boxImport->setGeometry(10,10,width()-20,245);
  edit  -> setGeometry(10, 20, (boxImport->width()-20), 25);
  label1 -> setGeometry(10,  55, (boxImport->width()/2-20), 15);
  label2 -> setGeometry(10,  75, (boxImport->width()/2-20), 15);
  label3 -> setGeometry(10,  95, (boxImport->width()/2-20), 15);
  label4 -> setGeometry(10, 115, (boxImport->width()/2-20), 15);
  label5 -> setGeometry(10, 135, (boxImport->width()/2-20), 15);
  label6 -> setGeometry(10, 155, (boxImport->width()/2-20), 15);
  label7 -> setGeometry(10, 175, (boxImport->width()/2-20), 15);
  label12 -> setGeometry(10,195, (boxImport->width()/2-20), 15);

  label13 -> setGeometry((boxImport->width()/2)+10, 55, (boxImport->width()/2-20), 15);
  label14 -> setGeometry((boxImport->width()/2)+10, 75, (boxImport->width()/2-20), 15);
  label19 -> setGeometry((boxImport->width()/2)+10, 95, (boxImport->width()/2-20), 15);
  label20 -> setGeometry((boxImport->width()/2)+10,115, (boxImport->width()/2-20), 15);
  label21 -> setGeometry((boxImport->width()/2)+10,135, (boxImport->width()/2-20), 15);
  label22 -> setGeometry((boxImport->width()/2)+10,155, (boxImport->width()/2-20), 15);
  label23 -> setGeometry((boxImport->width()/2)+10,175, (boxImport->width()/2-20), 15);

  labelTrenn -> setGeometry(10, 210, 80, 25);
  editTrenn -> setGeometry(90, 210, 40, 25);
  defaultButton -> setGeometry((boxImport->width()-90),205, 80,30);

  boxSave->setGeometry(10,265,width()-20, 65);
  useMP3CommentFieldBox->setGeometry(10,20,boxSave->width()-20,35);

  boxLoad->setGeometry(10,340,width()-20, 55);
  checkFilesBox->setGeometry(10,20,boxLoad->width()-20,25);
}



