    /*

    Copyright (C) 1999 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "iomanager.h"
#include "artsorb.h"
#include "debug.h"

IOManager::IOManager()
{
	running = false;
}

void IOManager::addFD(ArtsNotifyIO *notify, long ID, long type, int fd)
{
	ArtsIOEvent *ev = new ArtsIOEvent(notify,fd,type,ID);
	IOEvents.push_back(ev);

	if(running) ev->start();
}

void IOManager::remove(long ID)
{
	list<ArtsIOEvent *>::iterator ioevent = IOEvents.begin();

	while(ioevent!=IOEvents.end())
	{
		ArtsIOEvent *ev = (*ioevent);
		if(ev->ID() == ID)
		{
			ev->stop();
			delete ev;
			IOEvents.erase(ioevent);

			// and restart from the beginning because our iterator could
			// now point to nirwana
			ioevent = IOEvents.begin();

			artsdebug("removed io event\n");
		}
		else ioevent++;
	}
}

void IOManager::start()
{
	list<ArtsIOEvent *>::iterator ioevent;
	for (ioevent=IOEvents.begin(); ioevent != IOEvents.end(); ioevent++)
	{
		ArtsIOEvent *ev = (*ioevent);
		ev->start();
	}

	running = true;
}

void IOManager::stop()
{
	list<ArtsIOEvent *>::iterator ioevent;
	for (ioevent=IOEvents.begin(); ioevent != IOEvents.end(); ioevent++)
	{
		ArtsIOEvent *ev = (*ioevent);
		ev->stop();
	}

	running = false;
}
