	/*

	Copyright (C) 1998-1999 Stefan Westerfeld
                            stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#ifndef __MAIN_H__
#define __MAIN_H__

#include "arts.h"
#include "structure.h"
#include "scomponent.h"
#include "menumaker.h"

#include <list>

#include <kapp.h>
#include <ktopwidget.h>
#include <kfiledialog.h>
#include <ksimpleconfig.h>
#include <qlistbox.h>
#include <qtablevw.h>
#include <qpainter.h>
#include <qdrawutl.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qframe.h>
#include <qpixmap.h>
#include <qmsgbox.h>
#include <string.h>
#include "module.h"
#include "autorouter.h"
#include "portpropdlg.h"
#include "execdlg.h"
#include "namedlg.h"
#include "retrievedlg.h"
#include "utils.h"
#include "guiserver_impl.h"
#include "createtool.h"

class CreateTool;
class CreateModuleTool;
class CreatePortTool;

class ModuleWidget :public QTableView, public StructureCanvas
{
	Q_OBJECT
	friend CreateTool;
	friend CreateModuleTool;
	friend CreatePortTool;

protected:
	int cellsize,cols,rows;
	bool mouseButtonDown;
	QPoint movestart;
	bool inUpdate;

	CreateTool *activeTool;
	AutoRouter *autorouter;
	Structure *structure;

// for connecting ports

	ModulePort *lastport;
	int selectedports;

	//list<StructureComponent *> ChildList;
	list<Module *> *ModuleList;
	list<QRect> UpdateList;

	void paintCell(QPainter *p, int y, int x);
	void paintCellBackground(QPainter *p, int y, int x);
	void paintConnection(QPainter *p, int x, int y, int arx, int ary);
	void paintConnections(QPainter *p, int y, int x);
	void mousePressEvent( QMouseEvent *e );
	void mouseMoveEvent( QMouseEvent *e );
	void mouseReleaseEvent( QMouseEvent *e );

	bool hasSpace(StructureComponent *c,int destx,int desty,
											bool ignore_selected=false);
	bool connectPorts(ModulePort *src, ModulePort *dest);


	void reRoute();
	void setSelectAll(bool newstate);

	void beginUpdate();
	void redrawModule(Module *m);
	void redrawCells(QRect &r);
	void redrawAll();
	void endUpdate();

// for StructureComponents:

	void redrawRect(int x, int y, int width, int height);

// for CreateTool:

	bool insertModule(Module *newModule);
	void insertPort(Arts::PortType type, int x, int y);

public:
	Structure *theStructure();

	void addModule(Arts::ModuleInfo *minfo);
	void addPort(Arts::PortType type);
	void reInit();
	void leaveTool(CreateTool *tool);

	ModuleWidget(Structure *structure, QWidget *parent=0,
								const char *name=0, WFlags f=0);

	~ModuleWidget();

	ModulePort *findPort(Module *m, int xoffset, int direction);
public slots:
	void autoRedrawRouter();
	void setZoom(int zoom);
	void delModule();
	void selectAll();
	void unselectAll();
};

class ModuleView :public KTopLevelWidget
{
	Q_OBJECT
private:
    ModuleWidget *modulewidget;
	int modules_menu_item;
	KMenuBar *menubar;
	QPopupMenu *m_modules, *m_file, *m_view, *m_edit, *m_ports, *m_file_new;
	MenuMaker *menumaker;
	/*
	QPopupMenu *m_modules_synth,*m_modules_gui,*m_modules_instruments,
			   *m_modules_other;
	*/

	Arts::Synthesizer *Synthesizer;
	Arts::ModuleBroker_var ModuleBroker;
	GUIServer_impl *GUIServer;
	long mbroker_updateCount;
	//list<Module *> *ModuleList;
	Structure *structure;

	ExecDlg *execDlg;

public:
	ModuleView(const char *name, Arts::Synthesizer *Synthesizer);
	~ModuleView();
	void clear();
	void checkName();
	QString getOpenFilename(const char *pattern);

public slots:
	void addPort(int port);
	void fileNew(int what);
	void addModule(int module);
	void changePortPositions();
	void activateMenu(int item);
	void save();
	void open();
	void openSession();
	void execute();
	void endexecute();
	void rename();
	void retrieve();
	void publish();
	void quit();
};
#endif
