    /*

    Copyright (C) 1999 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "guipoti.h"
#include "kpoti.h"
#include "qframe.h"
#include "qbitmap.h"
#include "kiconloader.h"
#include "qpaintdevice.h"
#include "sequenceutils.h"

PotiIntMapper::PotiIntMapper(Gui_POTI *gp, KPoti *kp)
{
	connect(kp, SIGNAL(valueChanged(int)), this, SLOT(sendPosChange(int)));
	this->gp = gp;
}

void PotiIntMapper::sendPosChange(int pos)
{
	gp->sendPosChange(pos);
}

Gui_POTI::Gui_POTI()
{
	printf("constructor\n");
	Widget = 0;
	ParentWidget = 0;
	Mapper = 0;
}

Gui_POTI::~Gui_POTI()
{
	if(Mapper) delete Mapper;
	if(Widget)
	{
		printf("<deleting Gui_POTI>\n");
		delete Widget;
	}
}

void Gui_POTI::widgetDestroyed(QWidget *widget)
{
	assert(Widget == widget);
	Widget = 0;
}

void Gui_POTI::publish(Arts::ArtsServer *Server, Arts::ModuleBroker *Broker)
{
	Arts::ModuleInfo info;

	info.name = CORBA::string_dup("Gui_POTI");
	info.isInterface = false;
	info.isStructure = false;

	addPort(info,"parent",Arts::input,Arts::audio_data,Arts::stream);
	addPort(info,"x",Arts::input,Arts::audio_data,Arts::property);
	addPort(info,"y",Arts::input,Arts::audio_data,Arts::property);
	addPort(info,"color",Arts::input,Arts::string_data,Arts::property);
	addPort(info,"caption",Arts::input,Arts::string_data,Arts::property);
	addPort(info,"min",Arts::input,Arts::audio_data,Arts::property);
	addPort(info,"max",Arts::input,Arts::audio_data,Arts::property);
	addPort(info,"initial",Arts::input,Arts::audio_data,Arts::property);
	addPort(info,"value",Arts::output,Arts::audio_data,Arts::stream);

	Broker->publishModule(Server, info);
}

void *Gui_POTI::Creator()
{
	Gui_POTI *result = new Gui_POTI;
	return (GuiModule *)result;
}

ModuleClient MC_Gui_POTI(GuiModule::get_MS,"Gui_POTI",Gui_POTI::Creator);

void Gui_POTI::applyParameters(Arts::ModuleDesc *desc)
{
	KIconLoader iconloader;

	getPosition(desc,x,y);

	minvalue = getFloatParam(desc,"min");
	printf("got parameter minvalue %f\n",minvalue);
	maxvalue = getFloatParam(desc,"max");
	printf("got parameter maxvalue %f\n",maxvalue);
	initialvalue = getFloatParam(desc,"initial");
	if(initialvalue < minvalue) initialvalue = minvalue;
	if(initialvalue > maxvalue) initialvalue = maxvalue;
	currentvalue = initialvalue;
	printf("got parameter initialvalue %f\n",initialvalue);

	setupParent(desc,"parent");

	if(!Widget)
	{
		/*
		no initialvalue setting here any more due to session management

		long initiall =
			(long)(((initialvalue-minvalue)/(maxvalue-minvalue))*100.0+0.5);

		Widget = new KPoti(0,100,1,initiall);
		*/
		Widget = new KPoti(0,100,1,0);
		Mapper = new PotiIntMapper(this,Widget);
		watchWidget(Widget);
	}
	Widget->setFixedSize(46,40);

	string color = getStringParam(desc,"color");
	if(strlen(color.c_str()))
	{
		QColor qc(color.c_str());
		Widget->setColor(qc);
	}

	string caption = getStringParam(desc,"caption");
	if(strlen(caption.c_str()))
	{
		Widget->setName(caption.c_str());
	}

	valuePort = lookupPort(desc,"value");
}

void Gui_POTI::setParent(QWidget *parent, QBoxLayout *layout)
{
	if(Widget)
	{
		QPixmap bg(Widget->width(),Widget->height());
		bg.fill(parent,QPoint(x,y));

		printf("recreating widget...\n");
		Widget->recreate(parent,0,QPoint(x,y));
		Widget->setBackgroundPixmap(bg);

		if(layout)
		{
			printf("adding widget to layout\n");
			layout->addWidget(Widget);
		}
	}
	ParentWidget = parent;
}

void Gui_POTI::restoreSessionParameters(const Arts::StringSeq& params)
{
	unsigned long i;
   	char *cmd,*param;
   	for(i=0;i<params.length();i++)
   	{
   		if(parse_line(params[i],cmd,param))   // otherwise: empty or comment
   		{
   			if(strcmp(cmd,"value") == 0) {
   				currentvalue = atof(param);
			}
		}
   	}                                                                           
}

void Gui_POTI::finalize()
{
	// initialize the poti

	long value =
			(long)(((currentvalue-minvalue)/(maxvalue-minvalue))*100.0+0.5);
	Widget->setValue(value);

	// start emitting the right output value

	emitSignal(valuePort,currentvalue);
}

void Gui_POTI::start()
{
	Widget->show();
}

void Gui_POTI::sendPosChange(int pos)
{
	currentvalue = (((float)pos/100.0) * (maxvalue - minvalue))+minvalue;
	//printf("new slider position %d  -> mapped to %f\n",pos,sly);
	emitSignal(valuePort,currentvalue);
}

Arts::StringSeq *Gui_POTI::saveSessionParameters(list<long>&)
{
	Arts::StringSeq *params = new Arts::StringSeq;

	sqprintf(params,"value=%f",currentvalue);
	return params;
}
