	/*

	Copyright (C) 1998-1999 Stefan Westerfeld
                            stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#ifndef __GUIINSTDLG_H_
#define __GUIINSTDLG_H_

#include "arts.h"
#include <qdialog.h>
#include <qcombobox.h>
#include <qlistview.h>
#include <qlabel.h>
#include <qlined.h>
#include <vector>

class InstListViewItem : public QListViewItem {
	long instrumentID;
	Arts::Synthesizer_var Synthesizer;
	Arts::ModuleBroker_var ModuleBroker;

	float channel, maxVoices;
	string instrumentShort, destination;
public:
	/*
	InstListViewItem(Arts::Synthesizer_ptr Synthesizer, QListView *parent,
		     const char *a, const char *b, const char *c, long instrumentID);
	*/
	InstListViewItem(Arts::Synthesizer_ptr Synthesizer,
			Arts::ModuleBroker_ptr ModuleBroker, QListView *parent,
			float channel, float maxVoices, const char *instrumentShort,
			const char *destination);

	InstListViewItem::InstListViewItem(Arts::Synthesizer_ptr Synthesizer,
		Arts::ModuleBroker_ptr ModuleBroker, QListView *parent,
		const Arts::StringSeq& params, long restoreID);

	Arts::StringSeq *saveSessionParameters(list<long>& IDs);

	~InstListViewItem();
	const char *text(int column) const;
	const char *key(int column,bool ascending) const;

	Arts::StructureDesc *createStructure();
};

class GuiInstDlg :public QDialog {
	Q_OBJECT
protected:
	Arts::Synthesizer_var Synthesizer;
	Arts::ModuleBroker_var ModuleBroker;
	QComboBox *cbChannel, *cbInstrument, *cbDestination;
	QLineEdit *eMaxVoices;

public:
	GuiInstDlg(QWidget *parent, Arts::Synthesizer *Synthesizer);

	InstListViewItem *create(QListView *parent);
};

#endif
