    /*

    Copyright (C) 1999 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "guimodule.h"
#include "qwidget.h"
#include "qlabel.h"
#include "qlayout.h"
#include "qpixmap.h"
#include "qbitmap.h"
#include <qlistview.h>
#include "qobject.h"

class GuiAudioManagerProxy;

class Gui_AUDIO_MANAGER : public GuiModule
{
	QWidget *ParentWidget;
	QListView *listview;
	GuiAudioManagerProxy *proxy;
	Arts::AudioManager_var AudioManager;

	bool inDialog;
	unsigned long changes;
	int x,y;
public:
	Gui_AUDIO_MANAGER();
	~Gui_AUDIO_MANAGER();
	void publish(Arts::ArtsServer *Server, Arts::ModuleBroker *Broker);

	static void *Creator();

	void applyParameters(Arts::ModuleDesc *desc);
	void finalize();
	void start();
	void tick();
	void setParent(QWidget *Parent,QBoxLayout *layout);
	void widgetDestroyed(QWidget *widget);

	void edit(QListViewItem *item);
};

class GuiAudioManagerProxy :public QObject {
	Q_OBJECT
	Gui_AUDIO_MANAGER *gim;
public:
	GuiAudioManagerProxy(Gui_AUDIO_MANAGER *gim);
public slots:
	void edit(QListViewItem *item);
};

class AudioManagerItem : public QListViewItem {
	long _ID;
public:
	AudioManagerItem(QListView *parent, const char *a, const char *b,
			              const char *c, long ID);
	~AudioManagerItem();

	long ID();
};
