    /*

    Copyright (C) 1999 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "kbuttonbox.h"
#include "guiaudioman.h"
#include "qframe.h"
#include "qbitmap.h"
#include "kiconloader.h"
#include "qpaintdevice.h"
#include "choosebusdlg.h"
#include <kapp.h>

Gui_AUDIO_MANAGER::Gui_AUDIO_MANAGER()
{
	printf("constructor\n");
	ParentWidget = 0;
	listview = 0;
	inDialog = false;
	proxy = new GuiAudioManagerProxy(this);
}

Gui_AUDIO_MANAGER::~Gui_AUDIO_MANAGER()
{
	if(listview) delete listview;
	delete proxy;
}

void Gui_AUDIO_MANAGER::widgetDestroyed(QWidget *widget)
{
	assert(widget == listview);
	listview = 0;
}

void Gui_AUDIO_MANAGER::publish(Arts::ArtsServer *Server, Arts::ModuleBroker *Broker)
{
	Arts::ModuleInfo info;

	info.name = CORBA::string_dup("Gui_AUDIO_MANAGER");
	info.isInterface = false;
	info.isStructure = false;

	addPort(info,"parent",Arts::input,Arts::audio_data,Arts::stream);

	Broker->publishModule(Server, info);
}

void *Gui_AUDIO_MANAGER::Creator()
{
	Gui_AUDIO_MANAGER *result = new Gui_AUDIO_MANAGER;
	return (GuiModule *)result;
}

ModuleClient MC_Gui_AUDIO_MANAGER(GuiModule::get_MS,"Gui_AUDIO_MANAGER",Gui_AUDIO_MANAGER::Creator);

void Gui_AUDIO_MANAGER::applyParameters(Arts::ModuleDesc *desc)
{
	KIconLoader iconloader;

	setupParent(desc,"parent");
}

void Gui_AUDIO_MANAGER::setParent(QWidget *parent, QBoxLayout *layout)
{
/************************************************************************
 * From Gui_INSTRUMENT_MAPPER:
 *
 * I am still not sure wether this kind of putting yourself into a parent
 * widget (with own layout etc.) is a good idea (there may not even be
 * a singe call to setParent, because there is no parent).
 *
 * But the "how to write aRts widgets"-stuff will need some experiments,
 * so lets try that method...
 *
 * ----
 *
 * But perhaps here (since only one widget Listview is used) something
 * else would be appropriate. Check that. FIXME
 ************************************************************************/

	QVBoxLayout *mainlayout = new QVBoxLayout(parent);
	/*QHBoxLayout *contentslayout = new QHBoxLayout;*/

// list

	listview = new QListView(parent);

	listview->addColumn(i18n("Title"),175);
	listview->addColumn(i18n("Type"),50);
	listview->addColumn(i18n("Destination"),75);

	listview->setMinimumSize(300,100);

	watchWidget(listview);

	QObject::connect(listview,SIGNAL(doubleClicked(QListViewItem *)),proxy,
								SLOT(edit(QListViewItem *)));

	mainlayout->addWidget(listview);

	mainlayout->activate();
	//mainlayout->freeze();
	ParentWidget = parent;
}

void Gui_AUDIO_MANAGER::finalize()
{
	AudioManager = Synthesizer->audioManager();
}

void Gui_AUDIO_MANAGER::start()
{
	changes = AudioManager->changes()-1;
	tick();
}

void Gui_AUDIO_MANAGER::tick()
{
	if(inDialog) return;
	if(changes == AudioManager->changes()) return;

	changes = AudioManager->changes();

	listview->clear();
	Arts::AudioClientInfoSeq_var acs = AudioManager->clients();
 
	unsigned long c;
	for(c=0;c<acs->length();c++)
	{
		//char status[2][10] = {"init","running"};
		CORBA::String_var description = (*acs)[c].description;
		CORBA::String_var type = (*acs)[c].type;
		CORBA::String_var destination = (*acs)[c].destination;
		long ID = (*acs)[c].ID;
 
		(void)new AudioManagerItem(listview,description,type,destination,ID);
	}                                                                       
	//Widget->show();
}

void Gui_AUDIO_MANAGER::edit(QListViewItem *item)
{
	AudioManagerItem *ai = (AudioManagerItem *)item;
	ChooseBusDlg *cd = new ChooseBusDlg(0,Synthesizer);
	assert(cd);

	inDialog = true;
	bool accept = cd->exec();
	inDialog = false;

	if(accept)
	{
		const char *result = cd->result();
		if(result)
		{
			AudioManager->configureClient(ai->ID(),result);
			// refresh:
			start();
		}
	}
	delete cd;
}

GuiAudioManagerProxy::GuiAudioManagerProxy(Gui_AUDIO_MANAGER *gim)
{
	this->gim = gim;
}

void GuiAudioManagerProxy::edit(QListViewItem *item)
{
	gim->edit(item);
}

AudioManagerItem::AudioManagerItem(QListView *parent, const char *a,
         const char *b, const char *c, long ID) :QListViewItem(parent,a,b,c)
{
	_ID = ID;
}

long AudioManagerItem::ID()
{
	return _ID;
}

AudioManagerItem::~AudioManagerItem()
{
	//
}
