#ifndef _TXFACTORY_C_
#define _TXFACTORY_C_

#include "txFactory.h"
#include "txMain.h"
#include "txTrack.h"
#include "txPart.h"

#include <iostream.h>

TxFactory::TxFactory() {}

IfMain * TxFactory::createMain(KbMain * kbmain, int argc, char ** argv) {
  return new TxMain( kbmain, argc, argv );
}

IfTrack * TxFactory::createScoreTrack(KbTrack * kbtrack) {
  return new TxTrack(); // DOIT
}

IfTrack * TxFactory::createMasterTrack(KbTrack * kbtrack) {
  return new TxTrack(); // DOIT
}

IfPart * TxFactory::createPart() {
  return new TxPart();
}

IfPrefs * TxFactory::createPrefs() {
  return new IfPrefs();
}

IfEditor * TxFactory::createScoreEditor() {
  return new IfEditor();
}

IfEditor * TxFactory::createPianoEditor() {
  return new IfEditor();
}

IfEditor * TxFactory::createDrumEditor() {
  return new IfEditor();
}


#endif
