#ifndef _QTSELFRAME_H_
#define _QTSELFRAME_H_

#include "qtMain.h"
#include "kbPosition.h"

class QtEditor;
class KbMain;

class QtSelFrame : public QFrame
{
  Q_OBJECT
public:
  QtSelFrame( QWidget * parent, const char * name, KbMain * m );
  QLabel * top;
  QLabel * bottom;
  void setTop(int,int,int);
  void setTop(KbPosition);
  void setBottom(int,int,int);
  void setBottom(KbPosition);
 private:
  KbMain * main;
};

class Notebar;

class NoteEdit : public QLineEdit
{
  Q_OBJECT
private:
  int num;
  Notebar * nb;

public:
  NoteEdit( int n, QWidget * parent = 0, const char * name = 0 );

  void enable();

public slots:
  void focusOutEvent ( QFocusEvent * );
  void focusInEvent (QFocusEvent * );
};

class PopLabel : public QLabel
{
  Q_OBJECT
private:
  QPopupMenu * menu;
  int entry;
  QtEditor * editor;

public:
  PopLabel( QWidget * parent = 0, const char * name=0 );

public slots:
  void mousePressEvent ( QMouseEvent * );
  void select(int);
};

class Notebar : public KToolBar
// public QFrame
{
  Q_OBJECT
private:

  int pos;
  char position[32];
  char lengths[12];
  char pitch[12];
  char velocity[12];
  char channel[12];
  QLabel * qlPosition;
  int enhValue;
  PopLabel * enhLabel;
  NoteEdit * start;
  NoteEdit * length;
  NoteEdit * freq;
  NoteEdit * vel;
  NoteEdit * chan;
public:
  Notebar( QWidget *parent=0, const char *name=0 );
  
  QtEditor * editor;
  void setStart(int,int,int);
  void setLength(int);
  void setPitch(int);
  void setVelocity(int);
  void setEnh(int);
  void setChan(int);
  void clear();

public slots:
  void startCF();
  void lengthCF();
  void freqCF();
  void velCF();
  void chanCF();
  void startEnter();
  void lengthEnter();
  void freqEnter();
  void velEnter();
  void chanEnter();
};


#endif
