#ifndef _KBPART_H_
#define _KBPART_H_

#include "kbPosition.h"

class IfFactory;
class KbTrack;
class IfPart;
class KbMain;
class KbNote;
class KbAtom;
class KbMasterEvent;
class KbAuxElement;
class KbMidiEvent;
class KbLyrics;

/**
 * This class contains the properties of a part. Its (graphical) presentation is attached via the interface IfPart
 * @short Brahms Part
 * @author Jan Wuerthner
 * @see IfPart
 * @see QtPart
 */
class KbPart
{
 private:
  IfPart * ifPart;
  KbPart * next;
  KbTrack * track;
  int program;
  int time1;
  int time2;
  int key;
  int clef;
  KbPosition offset;
  KbAtom * first;
  KbAtom * last;
  KbAtom * cur;

 public:

  KbPart( KbTrack * kbTrack, KbPosition os = 0 );
  ~KbPart();
  IfPart * gInterface();
  KbTrack * gTrack();
  void setTrack(KbTrack*);
  KbPart * gNext();
  void sNext(KbPart * n);
  int gKey();
  void sKey(int);
  int gClef();
  void sClef(int);
  int gTime1();
  void sTime1(int);
  int gTime2();
  void sTime2(int);
  int gProgram();
  void sProgram(int);
  KbPosition gOffset();
  void sOffset(KbPosition);
  void snapOffset(int);
  void reorder();
  void split(unsigned long,int);
  void glue();
  void deletePart();
  
  KbAtom * gFirstAtom();
  KbAtom * gLastAtom();
  KbAtom * gCurAtom();
  KbNote * gFirstNote();
  KbNote * gFirstNote(KbAtom*&);
  KbNote * gLastNote();
  KbMasterEvent * gFirstMasterEvent();
  KbMasterEvent * gLastMasterEvent();
  KbMidiEvent * gFirstMidiEvent();
  KbMidiEvent * gLastMidiEvent();
  KbAuxElement * gFirstAuxElement();
  KbAuxElement * gLastAuxElement();
  //KbLyrics * gFirstLyrics();
  //KbLyrics * gLastLyrics();

  void sFirst(KbAtom * n);
  void sCur(KbAtom * n);
  void sLast(KbAtom * n);
  KbPosition gCurPos(bool);
  void reset();
  void iterate();
  KbAtom * copyAtom(bool);

  void addAtom(KbAtom * a);
  void addNote(KbNote * n);
  void appendNote(KbAtom * n);
  void selectNote(KbAtom * n);
  void deleteNote(KbAtom * n);
  void quantize(int q=0, KbPosition l=0, KbPosition r=0);
  void quantizeLength(int q=0, KbPosition l=0, KbPosition r=0);
  void fixedLength(int q=0, KbPosition l=0, KbPosition r=0);
  void erase(KbPosition l, KbPosition r);
  bool left();
  bool right();
  bool leftNote();
  bool rightNote();
  KbAuxElement * giveAux(KbPosition p, int sym, int off, int par=-1);

};

#endif
