#ifndef _KBPART_C_
#define _KBPART_C_

#include "kbPart.h"
#include "ifFactory.h"
#include "kbMain.h"
#include "ifPart.h"
#include "kbTrack.h"
#include "kbNote.h"
#include "kbLyrics.h"
#include "kbMidiEvent.h"
#include "kbAuxElement.h"
#include "kbMasterEvent.h"

KbPart::KbPart( KbTrack * kbTrack, KbPosition os )
  : track(kbTrack), next(0), key(0), clef(0), program(0),
    first(0), cur(0), last(0), offset(os)
{
  if (track) { time1 = kbTrack->gMain()->gMeter(0); time2 = kbTrack->gMain()->gMeter(1); }
  bool loop=true;
  KbPart * pp = 0;
  KbPart * pp1=0;

  if (track) {
    for (pp=kbTrack->gPart(); pp!=0; pp = pp->gNext()) { pp1=pp; }
    if (pp1==0) kbTrack->sPart(this);
    else pp1->sNext(this);
    
    ifPart = kbTrack->gMain()->gFactory()->createPart(this);
    reorder();
  } else ifPart = 0;
}

KbPart::~KbPart() {
  KbAtom * n;
  KbAtom * n1;
  n = first;
  while (n!=0) {
    if (n->gNext()==0) { delete n; n = 0; }
    else { n1 = n; n = n->gNext(); delete n1; }
  }
  first = 0; cur = 0; last = 0;
  gInterface()->erase();
}

IfPart * KbPart::gInterface() { return ifPart; }

KbTrack * KbPart::gTrack() {
  return track;
}

void KbPart::setTrack(KbTrack * t) {
  track = t;
  time1 = t->gMain()->gMeter(0); time2 = t->gMain()->gMeter(1);
  if (ifPart==0) ifPart = track->gMain()->gFactory()->createPart(this);
  reorder();
}

KbPart * KbPart::gNext() {
  return next;
}

void KbPart::sNext(KbPart * n) {
  next = n;
}


int KbPart::gKey() {
  return key;
}

void KbPart::sKey(int n) {
  key = n;
}

int KbPart::gClef() {
  return clef;
}

void KbPart::sClef(int n) {
  clef = n;
}

int KbPart::gTime1() {
  return time1;
}

void KbPart::sTime1(int t) {
  time1 = t;
}

int KbPart::gTime2() {
  return time2;
}

void KbPart::sTime2(int t) {
  time2 = t;
}


int KbPart::gProgram() {
  return program;
}

void KbPart::sProgram(int p) {
  program = p;
}

KbPosition KbPart::gOffset() {
  return offset;
}

void KbPart::sOffset(KbPosition p) {
  offset = p;
}

void KbPart::snapOffset(int s) {
  offset.snap(s);
  // do a reorder of parts if necessary
  reorder();
}

void KbPart::reorder() {
  if (gTrack() && gTrack()->gPart()) {
    KbPart * p = gTrack()->gPart();
    KbPart * p2;
    if (p->gNext()) {
      bool loop = true;
      while (loop) {
	loop = false;
	p = 0;
	for (KbPart * p1 = gTrack()->gPart();(p1!=0)&&(p1->gNext()!=0);p1=p1->gNext()) {
	  p2 = p1->gNext();
	  if (p2->gOffset() < p1->gOffset()) {
	    if (p!=0) { p->sNext(p2); p1->sNext(p2->gNext()); p2->sNext(p1); }
	    else { gTrack()->sPart(p2); p1->sNext(p2->gNext()); p2->sNext(p1); }
	    loop = true;
	  }
	  p = p1;
	}
      }
    }
  }
}

// ----------------------------------------

KbAtom * KbPart::gFirstAtom() {
  return first;
}

KbAtom * KbPart::gLastAtom() {
  return last;
}

KbAtom * KbPart::gCurAtom() {
  return cur;
}

// -- get first --

KbNote * KbPart::gFirstNote() {
  KbAtom * a = 0;
  for (a = first; (a!=0) && (a->isNote()==0); a = a->gNext()) {}
  return (KbNote*) a;
}

KbNote * KbPart::gFirstNote(KbAtom *& pre) {
  KbAtom * a = 0;
  pre = 0;
  for (a = first; (a!=0) && (a->isNote()==0); a = a->gNext()) { pre = a; }
  return (KbNote*) a;
}


KbMidiEvent * KbPart::gFirstMidiEvent() {
  KbAtom * a = 0;
  for (a = first; (a!=0) && (a->isMidiEvent()==0); a = a->gNext()) {}
  return (KbMidiEvent*) a;
}

KbAuxElement * KbPart::gFirstAuxElement() {
  KbAtom * a = 0;
  for (a = first; (a!=0) && (a->isAuxElement()==0); a = a->gNext()) {}
  return (KbAuxElement*) a;
}

KbMasterEvent * KbPart::gFirstMasterEvent() {
  KbAtom * a = 0;
  for (a = first; (a!=0) && (a->isMasterEvent()==0); a = a->gNext()) {}
  return (KbMasterEvent*) a;
}

// -- get last --

KbNote * KbPart::gLastNote() {
  KbAtom * a = last;
  while ((a!=0)&&(a->isNote()==0)) { sCur(a); left(); a=gCurAtom(); }
  return (KbNote*) a;
}

/*KbLyrics * KbPart::gLastLyrics() {
  KbAtom * a = last;
  while ((a!=0)&&(a->isLyrics()==0)) { sCur(a); left(); a=gCurAtom(); }
  return (KbLyrics*) a;
  }*/

KbMidiEvent * KbPart::gLastMidiEvent() {
  KbAtom * a = last;
  while ((a!=0)&&(a->isMidiEvent()==0)) { sCur(a); left(); a=gCurAtom(); }
  return (KbMidiEvent*) a;
}

KbAuxElement * KbPart::gLastAuxElement() {
  KbAtom * a = last;
  while ((a!=0)&&(a->isAuxElement()==0)) { sCur(a); left(); a=gCurAtom(); }
  return (KbAuxElement*) a;
}

KbMasterEvent * KbPart::gLastMasterEvent() {
  KbAtom * a = last;
  while ((a!=0)&&(a->isMasterEvent()==0)) { sCur(a); left(); a=gCurAtom(); }
  return (KbMasterEvent*) a;
}



// --

void KbPart::sFirst(KbAtom * n) {
  first = n;
}

void KbPart::sCur(KbAtom * n) {
  cur = n;
}

void KbPart::sLast(KbAtom * n) {
  last = n;
}


void KbPart::reset() { cur = first; }

void KbPart::iterate() { cur = cur->gNext(); }

KbPosition KbPart::gCurPos(bool absolutePosition) {
  if (cur) {
    if (absolutePosition) return cur->gPos()+offset;
    else return cur->gPos();
  }
}

KbAtom * KbPart::copyAtom(bool absolutePosition) {
  KbAtom * retv = 0;
  if (cur) {
    retv = cur->copy();
    if (absolutePosition) {
      retv->sPos(retv->gPos()+offset);
    }
  }
  return retv;
}


void KbPart::split(unsigned long split, int snap) {
  split += int(snap*0.5);
  split = split - (split%snap);
  if (split>offset.gPosTicks()) {
    KbPart * newPart = gTrack()->addPart(split);
    KbAtom * n;
    KbAtom * n1 = 0;
    for (n=gFirstAtom();(n!=0)&&(n->gPos()+offset.gPosTicks()<split);n=n->gNext()) { n1 = n; }
    if (n!=0) {
      if (n1==0) { // no notes remain in this part!
	newPart->sFirst(gFirstAtom()); newPart->sCur(gCurAtom()); newPart->sLast(gLastAtom());
	sFirst(0); sCur(0); sLast(0);
      } else { // part gets divided
	n1->sNext(0);
	newPart->sLast(gLastAtom());
	sLast(n1);
	sCur(gFirstAtom());
	newPart->sFirst(n);
	newPart->sCur(n);
	for (n=newPart->gFirstAtom();n!=0;n=n->gNext()) { n->sPos(n->gPos()-(split-offset)); }
      }
    }
    
  }
}

void KbPart::glue() {
  KbPart * pt = gNext();
  if (pt) {
    KbPosition shift = pt->gOffset() - gOffset();
    for (KbAtom * n=pt->gFirstAtom();n!=0;n=n->gNext()) {
      n->sPos(n->gPos()+shift);
    }
    KbAtom * last = gLastAtom();
    if (last!=0) last->sNext(pt->gFirstAtom());
    else sFirst(pt->gFirstAtom());
    sLast(pt->gLastAtom());
    pt->sFirst(0); pt->sCur(0); pt->sLast(0);
    pt->deletePart();
  }
}

void KbPart::deletePart() {
  KbPart * pt = 0;
  for (pt=gTrack()->gPart();pt!=0&&pt->gNext()!=this; pt=pt->gNext()) {}
  if (pt!=0) {
    pt->sNext(gNext());
    delete this;
  } else {
    gTrack()->sPart(gNext());
    delete this;
  }
  
}


// *******************************************************************************
//
// Note Handling
// =============
//



void KbPart::appendNote(KbAtom* n)
{
  if (last!=0)
    {
      last->sNext(n);
      last=n;
    } else {
      first=cur=last=n;
    }
}

#define X(s) cout << s << endl

void KbPart::addAtom(KbAtom * a) {
  //cout << "adding " << *a << endl << endl;
  //for (cur=first;cur!=0;cur=cur->gNext()) cout << *cur << endl;
  cur = first;
  KbAtom* prev=cur;
  if (first != 0) {
    if (last->gPos() < a->gPos()) {
      last->sNext(a);
      last=a;
    } else {
      if (a->gPos() < first->gPos()) {
	a->sNext(first);
	first=a;
      } else {
	// cout << "adding " << *a << " to atoms:" << endl;
	// for (cur=first;cur!=0;cur=cur->gNext()) cout << *cur << endl;
	for (cur=first; cur->gPos() < a->gPos(); cur=cur->gNext()) prev=cur;
	{ // a and cur at the same position (or a-pos smaller than cur-pos):
	  if (prev!=cur) {
	    a->sNext(cur);
	    prev->sNext(a);
	  } else {
	    first=a;
	    a->sNext(cur);
	  }
	}
	// for (cur=first;cur!=0;cur=cur->gNext()) cout << *cur << endl;
      }
    }
  } else {
    first=a;
    cur=a;
    last=a;
  }
}

void KbPart::addNote(KbNote* n)
{
  addAtom((KbAtom*)n);
  /*
  cur = first;
  KbAtom* prev=cur;
  if (first != 0) {
    if (last->gPos() < n->gPos()) {
      last->sNext(n);
      last=n;
    } else {
      if (n->gPos() < first->gPos()) {
	n->sNext(first);
	first=n;
      } else {
	for (cur=first; cur->gPos() < n->gPos(); cur=cur->gNext()) prev=cur;
	/ *
	if (cur->gPos()==n->gPos()) { // same position, put lower note before higher note:
	
	  if (n->isNote() && cur->isNote()) {
	    KbNote * curn = (KbNote*) cur;
	    KbNote * nn = (KbNote*) n;
	    KbNote * prevn = (KbNote*) prev;
	    for (;curn->gFreq()<nn->gFreq() && curn->gNext()!=0 && ((KbNote*)curn->gNext())->gPos()==nn->gPos();
		 curn=curn->gNextNote())
	      prevn=curn;
	    if (curn->gFreq() < nn->gFreq()) {
	      nn->sNext(curn->gNext());
	      curn->sNext(nn);
	      if (nn->gNext()==0) last=nn;
	    } else {
	      if (prevn!=curn) {
		nn->sNext(curn);
		prevn->sNext(nn);
	      } else {
		first=nn;
		nn->sNext(curn);
		if (curn->gNext()==0) last=curn;
	      }
	    }
	  }
	  
	} else 
	* /
	{
	  if (prev!=cur) {
	    n->sNext(cur);
	    prev->sNext(n);
	  } else {
	    first=n;
	    n->sNext(cur);
	    last=cur;
	  }
	}
      }
    }
  } else {
    first=n;
    cur=n;
    last=n;
  }
  */
}


void KbPart::selectNote(KbAtom* n)
{
  cur=n;
}

void KbPart::deleteNote(KbAtom* n)
{
  KbAtom* prev=first;
  for (cur=first; cur!=n; cur=cur->gNext())
    {prev=cur;}
  if (cur==first) { first=cur->gNext(); prev=first; } else { prev->sNext(cur->gNext()); }
  delete cur;
  if (first==0) { cur = 0; last = 0; }
  cur=prev;
  if (cur!=0)
    if (cur->gNext()==0) last=cur;
  
}


void KbPart::quantize(int q, KbPosition l, KbPosition r) {
  KbNote * left; KbNote * right; KbNote * note;
  int foo;
  unsigned long foo1;
  if (r!=0) {
    for (left=gFirstNote();left!=0 && left->gPos()<l;left=left->gNextNote()) {}
    for (right=left;right!=0 && right->gPos()<r;right=right->gNextNote()) {}
  } else { left = gFirstNote(); right = gLastNote(); }
  if (right==0) right = gLastNote();

  for (note=left;note!=0 && note != right->gNextNote();note=note->gNextNote()) {
    foo = note->gLen(); if (foo%q!=0) note->sLen(q*int(foo*1.0/q+0.5));
    if (note->gLen()==0) note->sLen(q);
    foo1 = note->gPos().gPosTicks(); if (foo1%q!=0) note->sPos(q*int(foo1*1.0/q+0.5));
  }
  /*
  KbNote * left; KbNote * right;
  int foo;
  if (r!=0) {
    for (left=first;left!=0 && left->gPos()<l;left=left->gNext()) {}
    for (right=left;right!=0 && right->gPos()<r;right=right->gNext()) {}
  } else { left = first; right = last; }
  if (right==0) right = last;

  for (cur=left;cur!=0 && cur != right->gNext();cur=cur->gNext()) {
    foo = cur->gLen(); if (foo%q!=0) cur->sLen(q*int(foo*1.0/q+0.5));
    if (cur->gLen()==0) cur->sLen(q);
    foo = cur->gPos(); if (foo%q!=0) cur->sPos(q*int(foo*1.0/q+0.5));
  }
  */
}

void KbPart::quantizeLength(int q, KbPosition l, KbPosition r) {
  KbNote * left; KbNote * right; KbNote * note;
  int foo;
  if (r!=0) {
    for (left=gFirstNote();left!=0 && left->gPos()<l;left=left->gNextNote()) {}
    for (right=left;right!=0 && right->gPos()<r;right=right->gNextNote()) {}
  } else { left = gFirstNote(); right = gLastNote(); }
  if (right==0) right = gLastNote();

  for (note=left;note!=0 && note != right->gNextNote();note=note->gNextNote()) {
    foo = note->gLen(); if (foo%q!=0) note->sLen(q*int(foo*1.0/q+0.5));
    if (note->gLen()==0) note->sLen(q);
  }
  /*
  KbNote * left; KbNote * right;
  int foo;
  if (r!=0) {
    for (left=first;left!=0 && left->gPos()<l;left=left->gNext()) {}
    for (right=left;right!=0 && right->gPos()<r;right=right->gNext()) {}
  } else { left = first; right = last; }
  if (right==0) right = last;

  for (cur=left;cur!=0 && cur != right->gNext();cur=cur->gNext()) {
    foo = cur->gLen(); if (foo%q!=0) cur->sLen(q*int(foo*1.0/q+0.5));
    if (cur->gLen()==0) cur->sLen(q);
  }
  */
}

void KbPart::fixedLength(int q, KbPosition l, KbPosition r) {
  KbNote * left; KbNote * right; KbNote * note;
  if (r!=0) {
    for (left=gFirstNote();left!=0 && left->gPos()<l;left=left->gNextNote()) {}
    for (right=left;right!=0 && right->gPos()<r;right=right->gNextNote()) {}
  } else { left = gFirstNote(); right = gLastNote(); }
  if (right==0) right = gLastNote();

  for (note=left;note!=0 && note != right->gNextNote();note=note->gNextNote()) note->sLen(q);
}


void KbPart::erase(KbPosition l, KbPosition r) {
  KbAtom * prevlnote = 0;
  KbAtom * lnote = 0;
  KbAtom * rnote = 0;
  KbAtom * nn1;
  for (cur=first;cur!=0;cur=cur->gNext()) {
    if (cur->gPos()>=l && lnote==0) lnote = cur;
    if (cur->gPos()<=r) rnote = cur;
    if (lnote==0) prevlnote = cur;
  }
  if (prevlnote==0) first = rnote->gNext();
  else prevlnote->sNext(rnote->gNext());
  if (rnote->gNext()==0) last = prevlnote;
  for (KbAtom * nn=lnote; nn!=rnote;) {
    nn1 = nn->gNext();
    delete nn;
    nn = nn1;
  }
  delete rnote;
  // cout << first << ", " << last << endl;
}

bool KbPart::right()
{
  if (cur!=0)
    {
      cur=cur->gNext();
      if (cur==0) { cur=first; return true; }
      else return false;
    }
}

bool KbPart::left()
{
  KbAtom* cc;
  cc=cur;
  if (cur!=0)
    {
      if (cur==first)
	{
	  cur=last;
	  return true;
	} else {
	  for (cur=first; cur->gNext() != cc; cur=cur->gNext()) {}
	  return false;
	}
      
    }
}

bool KbPart::rightNote()
{
  if (cur!=0)
    {
      cur=cur->gNextNote();
      if (cur==0) {
	cur=first;
	if (cur->isNote()==false) cur = cur->gNextNote();
	return true;
      }
      else return false;
    }
}

bool KbPart::leftNote()
{
  KbAtom* cc;
  cc=cur;
  if (cur!=0)
    {
      if (cur==first)
	{
	  cur=last;
	  if (cur->isNote()==false) return leftNote();
	  else return true;
	} else {
	  for (cur=first; cur->gNext() != cc; cur=cur->gNext()) {}
	  if (cur->isNote()==false) return leftNote();
	  return false;
	}
    }
}


KbAuxElement * KbPart::giveAux(KbPosition p, int sym, int off, int par) {
  KbAuxElement * nae = 0;

  KbAtom * last = 0;
  for (KbAtom * a = first; a!=0; a=a->gNext()) {
    if (a->isAuxElement() && (a->gPos()==p)) {
      if (((KbAuxElement*)a)->isAuxSymbol()) if  (((KbSymbol*)a)->gSymbol()==sym) nae = (KbSymbol*) a;
      if (((KbAuxElement*)a)->isAuxParSymbol()) if (((KbParSymbol*)a)->gSymbol()==sym) nae = (KbParSymbol*) a;
    }
    last = a;
  }
  if (nae==0) {
    if (par==-1) nae = new KbSymbol(p,sym,off);
    else           nae = new KbParSymbol(p,sym,off,par);
    addAtom(nae);
  }
  return nae;
}


#endif
